package com.liveperson.infra.preferences

import android.content.Context

/**
 * Sub class of LogPreferences class to cache Event Manager log events
 */
open class EventManagerPreferences: LogPreferences() {

    companion object {
        private const val TAG = "EventManagerPreferences"
        private const val KEY_LOG_SERVICE_TYPE_EVENT_MANAGER = "log_service_type_event_manager"
    }

    // Static log list to avoid multiple preference read operation
    var logs = HashSet<String>()

    /**
     * Initialize LP log shared preferences.
     */
    fun init(applicationContext: Context) {
        initialize(applicationContext)
    }

    /**
     * Add event to an existing list of events from preferences and store it
     */
    fun addEventToLogPreferences(event: String, brandId: String) {
        // If static array is empty, first fetch from shared pref
        if (logs.isEmpty()) {
            val storedLogs = getLogsFromPreferences(buildKey(brandId, KEY_LOG_SERVICE_TYPE_EVENT_MANAGER))
            if (!storedLogs.isNullOrEmpty()) {
                logs = storedLogs as HashSet<String>
            }
        }

        logs.add(event)
        // Save it in shared prefs
        storeLogsInPreferences(buildKey(brandId, KEY_LOG_SERVICE_TYPE_EVENT_MANAGER), logs)
    }

    fun fetchLogsFromPreferences(brandId: String): MutableSet<String>? {
        return getLogsFromPreferences(buildKey(brandId, KEY_LOG_SERVICE_TYPE_EVENT_MANAGER))
    }

    fun clearLogsFromPreferences(brandId: String) {
        logs.clear()
        removeLogsFromPreferences(buildKey(brandId, KEY_LOG_SERVICE_TYPE_EVENT_MANAGER))
    }
}