/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.preferences;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.VisibleForTesting;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.Consumer;
import com.liveperson.infra.utils.EncryptionVersion;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bH\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\bJ\u001c\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\bJ\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000eJ\u0012\u0010\u0013\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0006H\u0007J\u001a\u0010\u0015\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/liveperson/infra/preferences/AuthPreferences;", "", "applicationContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "preferences", "Landroid/content/SharedPreferences;", "buildKey", "", "key", "brandId", "clearAll", "", "getCachedConsumer", "Lcom/liveperson/infra/model/Consumer;", "getUnAuthToken", "defaultValue", "setCachedConsumer", "consumer", "setPreferenceDelegate", "prefs", "setUnAuthToken", "value", "Companion", "infra_release"})
public final class AuthPreferences {
    private SharedPreferences preferences;
    private static final String TAG = "AuthPreferences";
    private static final String LP_AUTH_SHARED_PREF_FILENAME = "lp_auth_shared_pref";
    private static final String KEY_IDP_DOMAIN = "idp_domain";
    private static final String OLD_KEY_IDP_DOMAIN = "idp";
    private static final String KEY_ACCOUNT_UN_AUTH_TOKEN = "account_un_auth_token";
    private static final String KEY_CONSUMER_ID = "consumer_id";
    private static final String KEY_ORIGINAL_CONSUMER_ID = "original_consumer_id";
    private static final String KEY_LP_TOKEN = "lp_token";
    private static final String KEY_AUTH_TYPE = "auth_type";
    private static final String KEY_AUTH_KEY = "auth_key";
    private static final String KEY_HOST_APP_JWT = "host_app_jwt";
    private static final String KEY_HOST_APP_REDIRECT_URI = "host_app_redirect_uri";
    private static final String KEY_PINNING_KEYS = "pinning_keys";
    private static AuthPreferences instance;
    public static final Companion Companion;

    @VisibleForTesting
    public final void setPreferenceDelegate(@Nullable SharedPreferences prefs) {
        this.preferences = prefs;
    }

    public final void setUnAuthToken(@Nullable String brandId, @Nullable String value) {
        block0: {
            SharedPreferences sharedPreferences = this.preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.putString(this.buildKey(KEY_ACCOUNT_UN_AUTH_TOKEN, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, value))) == null) break block0;
            sharedPreferences.apply();
        }
    }

    @Nullable
    public final String getUnAuthToken(@Nullable String brandId, @Nullable String defaultValue) {
        SharedPreferences sharedPreferences = this.preferences;
        return DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences != null ? sharedPreferences.getString(this.buildKey(KEY_ACCOUNT_UN_AUTH_TOKEN, brandId), defaultValue) : null);
    }

    public final void setCachedConsumer(@NotNull String brandId, @Nullable Consumer consumer) {
        block8: {
            SharedPreferences.Editor editor;
            Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
            SharedPreferences sharedPreferences = this.preferences;
            Object object = editor = sharedPreferences != null ? sharedPreferences.edit() : null;
            if (consumer == null) {
                SharedPreferences.Editor editor2 = editor;
                if (editor2 != null && (editor2 = editor2.remove(this.buildKey(KEY_CONSUMER_ID, brandId))) != null && (editor2 = editor2.remove(this.buildKey(KEY_ORIGINAL_CONSUMER_ID, brandId))) != null && (editor2 = editor2.remove(this.buildKey(KEY_LP_TOKEN, brandId))) != null && (editor2 = editor2.remove(this.buildKey(KEY_AUTH_TYPE, brandId))) != null && (editor2 = editor2.remove(this.buildKey(KEY_AUTH_KEY, brandId))) != null && (editor2 = editor2.remove(this.buildKey(KEY_HOST_APP_JWT, brandId))) != null && (editor2 = editor2.remove(this.buildKey(KEY_HOST_APP_REDIRECT_URI, brandId))) != null) {
                    editor2.remove(this.buildKey(KEY_PINNING_KEYS, brandId));
                }
            } else {
                SharedPreferences.Editor editor3 = editor;
                if (editor3 != null && (editor3 = editor3.putString(this.buildKey(KEY_CONSUMER_ID, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, consumer.getConsumerId()))) != null && (editor3 = editor3.putString(this.buildKey(KEY_ORIGINAL_CONSUMER_ID, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, consumer.getOriginalConsumerId()))) != null) {
                    editor3.putString(this.buildKey(KEY_LP_TOKEN, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, consumer.getLpToken()));
                }
                if (consumer.getLpAuthenticationParams() != null) {
                    SharedPreferences.Editor editor4 = editor;
                    if (editor4 != null && (editor4 = editor4.putInt(this.buildKey(KEY_AUTH_TYPE, brandId), consumer.getLpAuthenticationParams().getAuthType().getStorageVal())) != null && (editor4 = editor4.putString(this.buildKey(KEY_AUTH_KEY, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, consumer.getLpAuthenticationParams().getAuthKey()))) != null && (editor4 = editor4.putString(this.buildKey(KEY_HOST_APP_JWT, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, consumer.getLpAuthenticationParams().getHostAppJWT()))) != null) {
                        editor4.putString(this.buildKey(KEY_HOST_APP_REDIRECT_URI, brandId), DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, consumer.getLpAuthenticationParams().getHostAppRedirectUri()));
                    }
                    HashSet<String> keys = new HashSet<String>();
                    for (String key : consumer.getLpAuthenticationParams().getCertificatePinningKeys()) {
                        keys.add(DBEncryptionHelper.encrypt(EncryptionVersion.VERSION_1, key));
                    }
                    SharedPreferences.Editor editor5 = editor;
                    if (editor5 != null) {
                        editor5.putStringSet(this.buildKey(KEY_PINNING_KEYS, brandId), (Set)keys);
                    }
                }
            }
            SharedPreferences.Editor editor6 = editor;
            if (editor6 == null) break block8;
            editor6.apply();
        }
    }

    @Nullable
    public final Consumer getCachedConsumer(@Nullable String brandId) {
        CharSequence charSequence = brandId;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        LPAuthenticationParams authParams = null;
        Consumer consumer = null;
        SharedPreferences sharedPreferences = this.preferences;
        if (sharedPreferences != null) {
            if (sharedPreferences.contains(this.buildKey(KEY_AUTH_TYPE, brandId))) {
                SharedPreferences sharedPreferences2 = this.preferences;
                LPAuthenticationType authType = LPAuthenticationType.Companion.fromStorageVal(sharedPreferences2 != null ? sharedPreferences2.getInt(this.buildKey(KEY_AUTH_TYPE, brandId), LPAuthenticationType.SIGN_UP.getStorageVal()) : LPAuthenticationType.SIGN_UP.getStorageVal());
                authParams = new LPAuthenticationParams(authType);
                SharedPreferences sharedPreferences3 = this.preferences;
                authParams.setAuthKey(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences3 != null ? sharedPreferences3.getString(this.buildKey(KEY_AUTH_KEY, brandId), "") : null));
                SharedPreferences sharedPreferences4 = this.preferences;
                authParams.setHostAppJWT(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences4 != null ? sharedPreferences4.getString(this.buildKey(KEY_HOST_APP_JWT, brandId), "") : null));
                SharedPreferences sharedPreferences5 = this.preferences;
                authParams.setHostAppRedirectUri(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences5 != null ? sharedPreferences5.getString(this.buildKey(KEY_HOST_APP_REDIRECT_URI, brandId), "") : null));
                Object object = this.preferences;
                if (object == null || (object = object.getStringSet(this.buildKey(KEY_PINNING_KEYS, brandId), Collections.emptySet())) == null) {
                    Set set = Collections.emptySet();
                    object = set;
                    Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.emptySet()");
                }
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    authParams.addCertificatePinningKey(DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, key));
                }
            }
        }
        SharedPreferences sharedPreferences6 = this.preferences;
        String string = DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences6 != null ? sharedPreferences6.getString(this.buildKey(KEY_CONSUMER_ID, brandId), "") : null);
        if (string == null) {
            string = "";
        }
        String consumerId = string;
        SharedPreferences sharedPreferences7 = this.preferences;
        String string2 = DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences7 != null ? sharedPreferences7.getString(this.buildKey(KEY_ORIGINAL_CONSUMER_ID, brandId), "") : null);
        if (string2 == null) {
            string2 = "";
        }
        String originalConsumerId = string2;
        SharedPreferences sharedPreferences8 = this.preferences;
        String string3 = DBEncryptionHelper.decrypt(EncryptionVersion.VERSION_1, sharedPreferences8 != null ? sharedPreferences8.getString(this.buildKey(KEY_LP_TOKEN, brandId), "") : null);
        if (string3 == null) {
            string3 = "";
        }
        String lpToken = string3;
        CharSequence charSequence2 = consumerId;
        boolean bl3 = false;
        if (charSequence2.length() > 0) {
            charSequence2 = lpToken;
            bl3 = false;
            if (charSequence2.length() > 0) {
                consumer = new Consumer(authParams, brandId, consumerId, originalConsumerId, lpToken);
            }
        }
        return consumer;
    }

    private final String buildKey(String key, String brandId) {
        return key + "$$" + brandId;
    }

    public final void clearAll() {
        block0: {
            LPLog.INSTANCE.d(TAG, "clearAll: Clearing all data of Auth preferences");
            SharedPreferences sharedPreferences = this.preferences;
            if (sharedPreferences == null || (sharedPreferences = sharedPreferences.edit()) == null || (sharedPreferences = sharedPreferences.clear()) == null) break block0;
            sharedPreferences.apply();
        }
    }

    private AuthPreferences(Context applicationContext) {
        this.preferences = applicationContext.getSharedPreferences(LP_AUTH_SHARED_PREF_FILENAME, 0);
    }

    static {
        Companion = new Companion(null);
    }

    public /* synthetic */ AuthPreferences(Context applicationContext, DefaultConstructorMarker $constructor_marker) {
        this(applicationContext);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/liveperson/infra/preferences/AuthPreferences$Companion;", "", "()V", "KEY_ACCOUNT_UN_AUTH_TOKEN", "", "KEY_AUTH_KEY", "KEY_AUTH_TYPE", "KEY_CONSUMER_ID", "KEY_HOST_APP_JWT", "KEY_HOST_APP_REDIRECT_URI", "KEY_IDP_DOMAIN", "KEY_LP_TOKEN", "KEY_ORIGINAL_CONSUMER_ID", "KEY_PINNING_KEYS", "LP_AUTH_SHARED_PREF_FILENAME", "OLD_KEY_IDP_DOMAIN", "TAG", "instance", "Lcom/liveperson/infra/preferences/AuthPreferences;", "getInstance", "context", "Landroid/content/Context;", "infra_release"})
    public static final class Companion {
        @NotNull
        public final AuthPreferences getInstance(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (instance == null) {
                instance = new AuthPreferences(context, null);
            }
            AuthPreferences authPreferences = instance;
            if (authPreferences == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.liveperson.infra.preferences.AuthPreferences");
            }
            return authPreferences;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

