/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.database;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.liveperson.infra.database.DatabaseManager;
import com.liveperson.infra.database.transaction_helper.InsertOrUpdateSQLCommand;
import com.liveperson.infra.database.transaction_helper.SQLiteCommand;
import com.liveperson.infra.database.transaction_helper.UpdateSQLCommand;
import com.liveperson.infra.log.LPLog;
import java.util.List;

public class DBUtilities
implements Cloneable {
    private static final String TAG = "DBUtilities";
    public static final long ROW_UPDATED = -1L;
    private final DatabaseManager.DatabaseHelper mDBHelper;
    private String mTableName;

    DBUtilities(DatabaseManager.DatabaseHelper dbHelper) {
        this.mDBHelper = dbHelper;
    }

    void init(String tableName) {
        this.mTableName = tableName;
    }

    public long insert(ContentValues values) {
        SQLiteDatabase db = this.mDBHelper.getWritableDatabase();
        return db.insert(this.mTableName, null, values);
    }

    public long insertWithOnConflict(ContentValues values) {
        SQLiteDatabase db = this.mDBHelper.getWritableDatabase();
        return db.insertWithOnConflict(this.mTableName, null, values, 4);
    }

    public long replace(ContentValues values) {
        SQLiteDatabase db = this.mDBHelper.getWritableDatabase();
        return db.replace(this.mTableName, null, values);
    }

    public Cursor query(String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        return this.query(columns, selection, selectionArgs, groupBy, having, orderBy, null);
    }

    public Cursor query(String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy, String limit) {
        SQLiteDatabase db = this.mDBHelper.getReadableDatabase();
        Cursor cursor = db.query(this.mTableName, columns, selection, selectionArgs, groupBy, having, orderBy, limit);
        if (cursor != null) {
            cursor.moveToFirst();
        }
        return cursor;
    }

    public Cursor rawQuery(String sql, Object ... optionalParams) {
        SQLiteDatabase readableDatabase = this.mDBHelper.getReadableDatabase();
        String[] params = new String[optionalParams.length];
        for (int i = 0; i < optionalParams.length; ++i) {
            params[i] = optionalParams[i].toString();
        }
        return readableDatabase.rawQuery(sql, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insertOrUpdate(ContentValues contentValuesForInsert, ContentValues contentValuesForUpdate, String whereClause, String[] whereArgs) {
        long rowId;
        SQLiteDatabase db = this.mDBHelper.getWritableDatabase();
        try {
            db.beginTransaction();
            LPLog.INSTANCE.d(TAG, "insertOrUpdate started");
            rowId = this.insertOrUpdate(db, contentValuesForInsert, contentValuesForUpdate, whereClause, whereArgs);
            db.setTransactionSuccessful();
        }
        finally {
            try {
                db.endTransaction();
            }
            catch (Exception e) {
                LPLog.INSTANCE.w(TAG, "Error while ending transaction: ", e);
            }
        }
        return rowId;
    }

    private long insertOrUpdate(SQLiteDatabase db, ContentValues contentValuesForInsert, ContentValues contentValuesForUpdate, String whereClause, String[] whereArgs) {
        long rowId;
        Cursor c = db.rawQuery("SELECT * FROM " + this.mTableName + " WHERE " + whereClause, whereArgs);
        if (c.moveToFirst()) {
            c.close();
            LPLog.INSTANCE.d(TAG, "insertOrUpdate: update");
            db.update(this.mTableName, contentValuesForUpdate, whereClause, whereArgs);
            rowId = -1L;
        } else {
            c.close();
            LPLog.INSTANCE.d(TAG, "insertOrUpdate: insert");
            rowId = db.insertWithOnConflict(this.mTableName, null, contentValuesForInsert, 4);
        }
        return rowId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTransaction(List<SQLiteCommand> sqliteCommands) {
        SQLiteDatabase db = this.mDBHelper.getWritableDatabase();
        try {
            db.beginTransaction();
            LPLog.INSTANCE.d(TAG, "Transaction started");
            for (SQLiteCommand command : sqliteCommands) {
                switch (command.getType()) {
                    case 0: {
                        long rowId = db.insertWithOnConflict(this.mTableName, null, command.getContentValues(), 4);
                        command.onInserted(rowId);
                        break;
                    }
                    case 2: {
                        long rowId = this.insertOrUpdate(db, ((InsertOrUpdateSQLCommand)command).getContentValuesForInsert(), ((InsertOrUpdateSQLCommand)command).getContentValuesForUpdate(), ((InsertOrUpdateSQLCommand)command).getUpdateWhereClause(), ((InsertOrUpdateSQLCommand)command).getUpdateWhereArgs());
                        if (rowId == -1L) break;
                        command.onInserted(rowId);
                        break;
                    }
                    case 1: {
                        db.update(this.mTableName, command.getContentValues(), ((UpdateSQLCommand)command).getUpdateWhereClause(), ((UpdateSQLCommand)command).getUpdateWhereArgs());
                    }
                }
            }
            db.setTransactionSuccessful();
        }
        finally {
            try {
                db.endTransaction();
            }
            catch (Exception e) {
                LPLog.INSTANCE.w(TAG, "Error while ending transaction: ", e);
            }
        }
    }

    public int update(ContentValues values, String whereClause, String[] whereArgs) {
        SQLiteDatabase db = this.mDBHelper.getWritableDatabase();
        return db.update(this.mTableName, values, whereClause, whereArgs);
    }

    public int removeAll(String whereClause, String[] whereArgs) {
        SQLiteDatabase db = this.mDBHelper.getWritableDatabase();
        return db.delete(this.mTableName, whereClause, whereArgs);
    }
}

