/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Pair;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.utils.ThreadPoolExecutor;
import com.liveperson.infra.utils.TlsUtil;
import com.liveperson.infra.utils.Utils;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.CertificatePinner;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpHandler {
    private static final String TAG = "HttpHandler";
    private static List<Interceptor> mInterceptorList;

    public static void executeDelayed(HttpRequest request, long delay) {
        Runnable httpRunnable = HttpHandler.buildRunnableByType(request);
        ThreadPoolExecutor.executeDelayed(httpRunnable, delay);
    }

    public static void execute(HttpRequest request) {
        HttpHandler.executeDelayed(request, 0L);
    }

    public static void addInterceptors(List<Interceptor> interceptorList) {
        if (interceptorList != null && !interceptorList.isEmpty()) {
            LPLog.INSTANCE.d(TAG, "addInterceptors: adding interceptors to this HttpHandler");
            mInterceptorList = interceptorList;
        }
    }

    private static Runnable buildRunnableByType(final HttpRequest request) {
        return () -> {
            Request httpReq = HttpRequestBuilder.build(request);
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            TlsUtil.enableTls12ForKitKat(clientBuilder);
            clientBuilder.connectTimeout((long)request.getTimeout(), TimeUnit.MILLISECONDS);
            clientBuilder.writeTimeout((long)request.getTimeout(), TimeUnit.MILLISECONDS);
            clientBuilder.readTimeout((long)request.getTimeout(), TimeUnit.MILLISECONDS);
            clientBuilder.followRedirects(true);
            if (mInterceptorList != null) {
                for (Interceptor interceptor : mInterceptorList) {
                    clientBuilder.addInterceptor(interceptor);
                }
            }
            LPLog.INSTANCE.i(TAG, "URL: " + httpReq.url().host());
            if (request.getCertificatePinningKeys() != null) {
                CertificatePinner.Builder builder = new CertificatePinner.Builder();
                for (String key : request.getCertificatePinningKeys()) {
                    LPLog.INSTANCE.d(TAG, "Pinning Key: " + LPLog.INSTANCE.mask(key));
                    if (!Utils.isValidCertificateKey(key)) continue;
                    builder.add(httpReq.url().host(), new String[]{key});
                }
                CertificatePinner certificatePinner = builder.build();
                clientBuilder.certificatePinner(certificatePinner);
            }
            OkHttpClient okClient = clientBuilder.build();
            LPLog.INSTANCE.d(TAG, "Sending http request: " + httpReq.url() + (request.getCertificatePinningKeys() != null ? "with Pinning Keys " + LPLog.INSTANCE.mask(TextUtils.join((CharSequence)",", request.getCertificatePinningKeys())) : " with no Pinning Keys"));
            okClient.newCall(httpReq).enqueue(new Callback(){

                public void onFailure(@NonNull Call call, @NonNull IOException e) {
                    LPLog.INSTANCE.w(HttpHandler.TAG, "onFailure ", e);
                    request.processErrorResponse(e);
                }

                public void onResponse(@NonNull Call call, @NonNull Response response) {
                    LPLog.INSTANCE.i(HttpHandler.TAG, "onResponse from URL: " + response.request().url());
                    request.processResponse(response);
                }
            });
        };
    }

    private static class HttpRequestBuilder {
        private HttpRequestBuilder() {
        }

        public static Request build(HttpRequest request) {
            Request.Builder httpBuilder = new Request.Builder();
            httpBuilder.url(request.getUrl());
            switch (request.getMethod()) {
                case GET: {
                    httpBuilder.get();
                    break;
                }
                case HEAD: {
                    httpBuilder.head();
                    break;
                }
                case POST: {
                    httpBuilder.post(HttpRequestBuilder.getRequestBody(request));
                    break;
                }
                case PUT: {
                    httpBuilder.put(HttpRequestBuilder.getRequestBody(request));
                }
            }
            if (!request.getHeaders().isEmpty()) {
                for (Pair<String, String> header : request.getHeaders()) {
                    LPLog.INSTANCE.d(HttpHandler.TAG, "header.first " + (String)header.first + " header.second " + (String)header.second);
                    httpBuilder.addHeader((String)header.first, (String)header.second);
                }
            }
            return httpBuilder.build();
        }

        @NonNull
        private static RequestBody getRequestBody(HttpRequest request) {
            RequestBody reqBody;
            HttpRequestBody requestBody = request.getRequestBody();
            if (requestBody != null) {
                MediaType type = MediaType.parse((String)requestBody.getContentType());
                reqBody = requestBody.isString() ? RequestBody.create((MediaType)type, (String)((String)requestBody.get())) : RequestBody.create((MediaType)type, (byte[])((byte[])requestBody.get()));
            } else {
                reqBody = RequestBody.create(null, (byte[])new byte[0]);
            }
            return reqBody;
        }
    }
}

