/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.requests;

import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import java.util.List;

public class BadgeCounterRequest
implements Command {
    private static final String TAG = "BadgeCounterRequest";
    private static final int BADGE_REQUEST_TIMEOUT = 30000;
    private String mPusherURL;
    private String mToken;
    private ICallback<String, Exception> mCallback;
    private List<String> mCertificates;

    public BadgeCounterRequest(String pusherURL, String token, List<String> certificates, ICallback<String, Exception> callback) {
        this.mPusherURL = pusherURL;
        this.mToken = token;
        this.mCallback = callback;
        this.mCertificates = certificates;
    }

    @Override
    public void execute() {
        HttpGetRequest httpGetRequest = new HttpGetRequest(this.mPusherURL);
        httpGetRequest.setTimeout(30000);
        httpGetRequest.addHeader("authorization", "bearer " + this.mToken);
        httpGetRequest.setCertificatePinningKeys(this.mCertificates);
        LPLog.INSTANCE.i(TAG, "Pusher url " + this.mPusherURL);
        httpGetRequest.setCallback(new ICallback<String, Exception>(){

            @Override
            public void onSuccess(String json) {
                if (!TextUtils.isEmpty((CharSequence)json)) {
                    LPLog.INSTANCE.i(BadgeCounterRequest.TAG, "onSuccess " + LPLog.INSTANCE.mask(json));
                    if (BadgeCounterRequest.this.mCallback != null) {
                        BadgeCounterRequest.this.mCallback.onSuccess(json);
                        return;
                    }
                }
                if (BadgeCounterRequest.this.mCallback != null) {
                    BadgeCounterRequest.this.mCallback.onError(new Exception("Error: empty response from the server"));
                }
            }

            @Override
            public void onError(Exception exception) {
                if (exception != null) {
                    if (BadgeCounterRequest.this.hasUnKnownError(exception.getMessage())) {
                        LPLog.INSTANCE.e(BadgeCounterRequest.TAG, ErrorCode.ERR_0000004B, "onError ", exception);
                    }
                    if (BadgeCounterRequest.this.mCallback != null) {
                        BadgeCounterRequest.this.mCallback.onError(exception);
                        return;
                    }
                }
                if (BadgeCounterRequest.this.mCallback != null) {
                    BadgeCounterRequest.this.mCallback.onError(new Exception("Error: request failed"));
                }
            }
        });
        HttpHandler.execute(httpGetRequest);
    }

    private boolean hasUnKnownError(String error) {
        return !error.contains("\"statusCode\":404,\"internalCode\":23");
    }
}

