package com.liveperson.infra.database.tables;


import android.database.sqlite.SQLiteDatabase;

/**
 * Created by shayl on 7/22/2015.
 */
public class BrandProfileTable implements BaseTable {

    private static final String TAG = BrandProfileTable.class.getSimpleName();

    //Brand profile table name
    public static final String BRAND_TABLE = "brandProfile";

    //Brand profile table columns
    public static final String KEY_BIO = "bio";
    public static final String KEY_BRAND_ID = "brandId";
    public static final String KEY_SKILL = "skill";
    public static final String KEY_COVER_IMAGE = "coverImage";
    public static final String KEY_NAME = "name";
    public static final String KEY_LOGO_IMAGE = "logoImage";
    public static final String KEY_IS_SAVED = "isSaved";

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public String getCreateCommand() {
        return new StringBuilder()
                .append("create table " + BRAND_TABLE + "(")
                .append(KEY_ID + " integer primary key autoincrement,")
                .append(KEY_BIO + " text,")
                .append(KEY_NAME + " text not null,")
                .append(KEY_BRAND_ID + " text not null,")
                .append(KEY_SKILL + " text,")
                .append(KEY_LOGO_IMAGE + " text,")
                .append(KEY_IS_SAVED + " integer,")
                .append(KEY_COVER_IMAGE + " text")
                .append(");")
                .toString();
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        //TODO: Currently we drop the existing table, and create a new one
        //TODO: need to handle data migration when we will be in production
    }
}
