package com.liveperson.infra.log;

import android.util.Log;

/**
 * Created by shiranr on 14/03/2016.
 */
public class DefaultAndroidLogger implements ILogger {
    @Override
    public void d(String tag, String string) {
        if (string != null) {
            Log.d(tag, string);
        }
    }

    @Override
    public void d(String tag, String error, Throwable t) {
        if (error != null) {
            Log.d(tag, error, t);
        }
    }

    @Override
    public void i(String tag, String string) {
        if (string != null) {
            Log.i(tag, string);
        }
    }

    @Override
    public void e(String tag, String string) {
        if (string != null) {
            Log.e(tag, string);
        }
    }

    @Override
    public void e(String tag, String error, Throwable t) {
        if (error != null) {
            Log.e(tag, error, t);
        }
    }

    @Override
    public void w(String tag, String string) {
        if (string != null) {
            Log.w(tag, string);
        }
    }

    @Override
    public void w(String tag, String error, Throwable t) {
        if (error != null) {
            Log.w(tag, error, t);
        }
    }
}
