package com.liveperson.infra.network.http.requests;

import android.text.TextUtils;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;

import java.util.List;

/**
 * Created by nirni on 12/29/15.
 * <p/>
 * This is an HTTP request to the configuration server to get the supported version
 */
public class ConfigurationRequest implements Command {

    public static final String TAG = ConfigurationRequest.class.getSimpleName();
    private static final int CONFIGURATION_REQUEST_TIMEOUT = 30000;

    // The URL to get the version
    private static final String CONFIGURATION_URL = "https://%s/mobile/configuration/androidConfig.json";

    private String mConfigurationDomain;
    private ICallback mCallback;
    private List<String> mCertificates;

    public ConfigurationRequest(String configurationDomain, List<String> certificates, ICallback callback) {
        mConfigurationDomain = configurationDomain;
        mCertificates = certificates;
        mCallback = callback;
    }

    @Override
    public void execute() {

        String versionUrl = String.format(CONFIGURATION_URL, mConfigurationDomain);

        HttpGetRequest httpGetRequest = new HttpGetRequest(versionUrl);
        httpGetRequest.setTimeout(CONFIGURATION_REQUEST_TIMEOUT);
        httpGetRequest.setCertificatePinningKeys(mCertificates);
        httpGetRequest.setCallback(new ICallback<String, Exception>() {
            @Override
            public void onSuccess(String configurationStr) {
                if (!TextUtils.isEmpty(configurationStr)) {
                    LPMobileLog.d(TAG, "configurationRequest - onCompleted " + configurationStr);
                    mCallback.onSuccess(configurationStr);
                } else {
                    LPMobileLog.e(TAG, "onSuccess: configuration string is empty");
                    mCallback.onError(new Exception("Configuration string is empty"));
                }
            }

            @Override
            public void onError(Exception e) {
                LPMobileLog.d(TAG, "Exception: " + e.getMessage());
                mCallback.onError(e);
            }
        });
        HttpHandler.execute(httpGetRequest);
    }
}
