package com.liveperson.infra.utils;

import android.content.Intent;
import android.os.Bundle;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPMobileLog;

/**
 * Created by ofira on 16/11/2015.
 */
public class LocalBroadcast {

    private static final String TAG = LocalBroadcast.class.getSimpleName();
    /**
     * Utils method to send local broadcast
     *
     * @param action - The broadcast action
     */
    public static void sendBroadcast(String action) {
        Intent sendIntent = new Intent(action);
        try {
            LocalBroadcastManager.getInstance(Infra.instance.getApplicationContext()).sendBroadcast(sendIntent);
        } catch (Exception e) {
            LPMobileLog.e(TAG, "Failed to send broadcast with action: " + action + ". And Reason is: " + e);
        }
    }

    /**
     * Utils method to send local broadcast with bundle
     *
     * @param action - The broadcast action
     * @param bundle - The Bundle of extras to add to this broadcast.
     */
    public static void sendBroadcast(String action, Bundle bundle) {
        Intent sendIntent = new Intent(action);
        sendIntent.putExtras(bundle);
        try {
            LocalBroadcastManager.getInstance(Infra.instance.getApplicationContext()).sendBroadcast(sendIntent);
        } catch (Exception e) {
            LPMobileLog.e(TAG, "Failed to send broadcast with action: " + action + " and bundle: " + bundle.toString() + ". And Reason is: " + e);
        }
    }

}
