/* Copyright (c) LivePerson, Inc. */
package com.liveperson.infra.utils;

import android.content.Context;
import android.os.Build;

import com.liveperson.infra.utils.picasso.OkHttp3Downloader;
import com.liveperson.infra.utils.picasso.Picasso;

import okhttp3.OkHttpClient;

/**
 * Created by Yanda on 2019/07/30
 * Picasso util class to enable TLSv1.2 for Android 4.4
 */
public class PicassoUtils {

    private static boolean initialized;

    public static Picasso get(Context context) {
        if (Build.VERSION.SDK_INT == Build.VERSION_CODES.KITKAT && !initialized) {
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            TlsUtil.enableTls12ForKitKat(clientBuilder);
            Picasso picasso = new Picasso.Builder(context)
                    .downloader(new OkHttp3Downloader(clientBuilder.build()))
                    .build();
            initialized = true;
            Picasso.setSingletonInstance(picasso);
        }
        return Picasso.get();
    }
}
