/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network;

import com.liveperson.infra.network.BackOff;

public class ExponentialBackOff
implements BackOff {
    private static final String TAG = ExponentialBackOff.class.getSimpleName();
    public static final int DEFAULT_INITIAL_INTERVAL_MILLIS = 500;
    public static final double DEFAULT_RANDOMIZATION_FACTOR = 0.0;
    public static final double DEFAULT_MULTIPLIER = 1.5;
    public static final int DEFAULT_MAX_INTERVAL_MILLIS = 60000;
    public static final int DEFAULT_MAX_ELAPSED_TIME_MILLIS = 900000;
    private final int mInitialIntervalMillis;
    private int mCurrentIntervalMillis;
    private final double mRandomizationFactor;
    private final double mMultiplier;
    private final int mMaxIntervalMillis;
    private final int mMaxElapsedTimeMillis;
    private long mStartTimeNanos;
    private int mRetryNumber;
    private long mNextDelay;

    private ExponentialBackOff(Builder builder) {
        this.mInitialIntervalMillis = builder.initialIntervalMillis;
        this.mRandomizationFactor = builder.randomizationFactor;
        this.mMultiplier = builder.multiplier;
        this.mMaxIntervalMillis = builder.maxIntervalMillis;
        this.mMaxElapsedTimeMillis = builder.maxElapsedTimeMillis;
        this.mRetryNumber = 0;
        this.reset();
    }

    @Override
    public void reset() {
        this.mCurrentIntervalMillis = this.mInitialIntervalMillis;
        this.mStartTimeNanos = System.nanoTime();
        this.mRetryNumber = 0;
        this.mNextDelay = 0L;
    }

    @Override
    public long getNextBackOffMillis() {
        return this.mNextDelay;
    }

    @Override
    public void calculateNextBackOffMillis() {
        if (this.getElapsedTimeMillis() > (long)this.mMaxElapsedTimeMillis) {
            this.mRetryNumber = 0;
            this.mNextDelay = -1L;
            return;
        }
        this.mNextDelay = this.getRandomValueFromInterval(this.mRandomizationFactor, Math.random(), this.mCurrentIntervalMillis);
        if (this.mNextDelay >= (long)this.mMaxIntervalMillis) {
            this.mRetryNumber = 0;
            this.mNextDelay = -1L;
            return;
        }
        ++this.mRetryNumber;
        this.incrementCurrentInterval();
    }

    @Override
    public int getRetryNumber() {
        return this.mRetryNumber;
    }

    private long getElapsedTimeMillis() {
        return (System.nanoTime() - this.mStartTimeNanos) / 1000000L;
    }

    private long getRandomValueFromInterval(double randomizationFactor, double random, int currentIntervalMillis) {
        double delta = randomizationFactor * (double)currentIntervalMillis;
        double minInterval = (double)currentIntervalMillis - delta;
        double maxInterval = (double)currentIntervalMillis + delta;
        int randomValue = (int)(minInterval + random * (maxInterval - minInterval + 1.0));
        return randomValue * 1000;
    }

    private void incrementCurrentInterval() {
        this.mCurrentIntervalMillis = (double)this.mCurrentIntervalMillis >= (double)this.mMaxIntervalMillis / this.mMultiplier ? this.mMaxIntervalMillis : (int)((double)this.mCurrentIntervalMillis * this.mMultiplier);
    }

    public static class Builder {
        int initialIntervalMillis = 500;
        double randomizationFactor = 0.0;
        double multiplier = 1.5;
        int maxIntervalMillis = 60000;
        int maxElapsedTimeMillis = 900000;

        public ExponentialBackOff build() {
            return new ExponentialBackOff(this);
        }

        public Builder setInitialIntervalMillis(int initialIntervalMillis) {
            this.initialIntervalMillis = initialIntervalMillis;
            return this;
        }

        public Builder setRandomizationFactor(double randomizationFactor) {
            this.randomizationFactor = randomizationFactor;
            return this;
        }

        public Builder setMultiplier(double multiplier) {
            this.multiplier = multiplier;
            return this;
        }

        public Builder setMaxIntervalMillis(int maxIntervalMillis) {
            this.maxIntervalMillis = maxIntervalMillis;
            return this;
        }

        public Builder setMaxElapsedTimeMillis(int maxElapsedTimeMillis) {
            this.maxElapsedTimeMillis = maxElapsedTimeMillis;
            return this;
        }
    }
}

