/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.requests;

import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import java.util.List;

public class ConfigurationRequest
implements Command {
    public static final String TAG = ConfigurationRequest.class.getSimpleName();
    private static final int CONFIGURATION_REQUEST_TIMEOUT = 30000;
    private static final String CONFIGURATION_URL = "https://%s/mobile/configuration/androidConfig.json";
    private String mConfigurationDomain;
    private ICallback mCallback;
    private List<String> mCertificates;

    public ConfigurationRequest(String configurationDomain, List<String> certificates, ICallback callback) {
        this.mConfigurationDomain = configurationDomain;
        this.mCertificates = certificates;
        this.mCallback = callback;
    }

    @Override
    public void execute() {
        String versionUrl = String.format(CONFIGURATION_URL, this.mConfigurationDomain);
        HttpGetRequest httpGetRequest = new HttpGetRequest(versionUrl);
        httpGetRequest.setTimeout(30000);
        httpGetRequest.setCertificatePinningKeys(this.mCertificates);
        httpGetRequest.setCallback(new ICallback<String, Exception>(){

            @Override
            public void onSuccess(String configurationStr) {
                if (!TextUtils.isEmpty((CharSequence)configurationStr)) {
                    LPMobileLog.d(TAG, "configurationRequest - onCompleted " + configurationStr);
                    ConfigurationRequest.this.mCallback.onSuccess(configurationStr);
                } else {
                    LPMobileLog.e(TAG, "onSuccess: configuration string is empty");
                    ConfigurationRequest.this.mCallback.onError(new Exception("Configuration string is empty"));
                }
            }

            @Override
            public void onError(Exception e) {
                LPMobileLog.d(TAG, "Exception: " + e.getMessage());
                ConfigurationRequest.this.mCallback.onError(e);
            }
        });
        HttpHandler.execute(httpGetRequest);
    }
}

