/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.requests;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.http.requests.PushRequest;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class UnregisterPushRequest
extends PushRequest {
    public static final String TAG = UnregisterPushRequest.class.getSimpleName();

    public UnregisterPushRequest(String pusherURL, String userId, String appId, List<String> certificates) {
        super(pusherURL, userId, appId, null, null, certificates);
    }

    @Override
    public void handleResponse(String json) {
        if (!TextUtils.isEmpty((CharSequence)json)) {
            LPMobileLog.d(TAG, "onSuccess " + json);
            if (this.mCallback != null) {
                this.mCallback.onSuccess(null);
            }
        } else {
            LPMobileLog.e(TAG, "Unregister pusher with empty response");
        }
    }

    @Override
    public void handleError(Exception exception) {
        if (exception != null) {
            LPMobileLog.d(TAG, "onError " + exception.getMessage());
            if (this.mCallback != null) {
                if (exception.getMessage().contains("Token not found")) {
                    LPMobileLog.d(TAG, "handleError: token not found on pusher. Return success");
                    this.mCallback.onSuccess(null);
                    return;
                }
                this.mCallback.onError(new Exception("Failed to unregister to pusher. response message = " + exception.getMessage()));
            }
        }
    }

    @Override
    @NonNull
    protected JSONObject getBody() {
        JSONObject pusherJson = new JSONObject();
        try {
            pusherJson.put("appId", (Object)this.mAppId);
            pusherJson.put("lpid", (Object)this.mUserId);
            pusherJson.put("platform", (Object)this.mPlatform);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return pusherJson;
    }
}

