/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPMobileLog;
import java.util.Arrays;

public class SDKUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static SDKUncaughtExceptionHandler instance;
    private static final String TAG;
    private static final long CRASH_IN_LOOP = 5000L;
    private final Thread.UncaughtExceptionHandler rootHandler;
    private static long lastCrashTime;

    private SDKUncaughtExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.rootHandler = exceptionHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SDKUncaughtExceptionHandler getInstance(Thread.UncaughtExceptionHandler root) {
        String string2 = TAG;
        synchronized (string2) {
            if (instance == null) {
                instance = new SDKUncaughtExceptionHandler(root);
            }
        }
        return instance;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (this.isExceptionFromSDK(ex)) {
            try {
                if (System.currentTimeMillis() - lastCrashTime < 5000L) {
                    LPMobileLog.e(TAG + ": LOOP! " + thread.getName(), ex);
                    return;
                }
                lastCrashTime = System.currentTimeMillis();
                LPMobileLog.e(TAG + ": " + thread.getName(), ex);
                Infra.instance.restart();
            }
            catch (Exception e) {
                LPMobileLog.e(TAG, e);
            }
        }
        if (this.rootHandler != null) {
            this.rootHandler.uncaughtException(thread, ex);
        }
    }

    private boolean isExceptionFromSDK(Throwable ex) {
        String check = SDKUncaughtExceptionHandler.exceptionStacktraceToString(ex);
        return check.contains("com.liveperson");
    }

    private static String exceptionStacktraceToString(Throwable e) {
        return Arrays.toString(e.getStackTrace());
    }

    static {
        TAG = SDKUncaughtExceptionHandler.class.getSimpleName();
        lastCrashTime = 0L;
    }
}

