package com.liveperson.infra.database.tables;


import android.database.sqlite.SQLiteDatabase;

/**
 * Created by shayl on 7/22/2015.
 */
public class UsersTable implements BaseTable {

    private static final String TAG = UsersTable.class.getSimpleName();

    //Users table name
    public static final String USERS_TABLE = "users";

    //Users table columns
    public static final String KEY_DESCRIPTION = "description";
    public static final String KEY_FIRST_NAME = "firstName";
    public static final String KEY_LAST_NAME = "lastName";
    public static final String KEY_NICKNAME = "nickname";
    public static final String KEY_PHONE_NUMBER = "phoneNumber";
    public static final String KEY_USER_TYPE = "userType";
    public static final String KEY_ORIGINATOR_ID = "originatorId";
    public static final String KEY_BRAND_ID = "brandId";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_PROFILE_IMAGE = "profileImage";
    public static final String KEY_COVER_IMAGE = "coverImage";
    public static final String KEY_REQUEST_ID = "requestId";
    public static final String KEY_ENCRYPTION_VERSION = "encryptVer";

    public static final String ENCRYPTION_VERSION_CURSOR_AS_VALUE = "user_encryptVer";

    @Override
    public String getName() {
        return TAG;
    }

    @Override
    public String getCreateCommand() {
        return new StringBuilder()
                .append("create table ").append(USERS_TABLE).append("(")
                .append(KEY_ID).append(" integer primary key autoincrement,")
                .append(KEY_ORIGINATOR_ID).append(" text unique not null,")
                .append(KEY_BRAND_ID).append(" text,")
                .append(KEY_DESCRIPTION).append(" text,")
                .append(KEY_FIRST_NAME).append(" text not null,")
                .append(KEY_LAST_NAME).append(" text,")
                .append(KEY_NICKNAME).append(" text,")
                .append(KEY_PHONE_NUMBER).append(" text,")
                .append(KEY_USER_TYPE).append(" integer not null,")
                .append(KEY_REQUEST_ID).append(" big int,")
                .append(KEY_EMAIL).append(" text,")
                .append(KEY_PROFILE_IMAGE).append(" text,")
                .append(KEY_ENCRYPTION_VERSION).append(" integer not null,")
                .append(KEY_COVER_IMAGE).append(" text")
                .append(");")
                .toString();
    }

    @Override
    public void onTableUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        //TODO: Currently we drop the existing table, and create a new one
        //TODO: need to handle data migration when we will be in production
    }

    public static String[] getProjection() {
        return new String[]{KEY_BRAND_ID, KEY_DESCRIPTION, KEY_FIRST_NAME, KEY_LAST_NAME, KEY_PHONE_NUMBER, KEY_USER_TYPE, KEY_REQUEST_ID, KEY_EMAIL, KEY_PROFILE_IMAGE, KEY_COVER_IMAGE};
    }
}
