/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.log;

import androidx.annotation.NonNull;
import com.liveperson.infra.Infra;
import com.liveperson.infra.log.AndroidLogger;
import com.liveperson.infra.log.Logger;
import com.liveperson.infra.log.logreporter.loggos.Loggos;
import com.liveperson.infra.log.logreporter.loggos.LoggosMessage;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LPMobileLog {
    private static final String TAG = "LivePerson";
    private static boolean DEBUG = true;
    private static boolean isLoggosEnabled = true;
    private static final String LOGGOS_CONTEXT = "AndroidSdk";
    private static final String INFO = "INFO";
    private static final String WARN = "WARN";
    private static final String ERROR = "ERROR";
    private static Logger logger = new AndroidLogger();

    public static void setLogger(Logger logger) {
        LPMobileLog.logger = logger;
    }

    public static void setLoggosEnabled(boolean enabled) {
        isLoggosEnabled = enabled;
    }

    public static void setDebugMode(boolean debugMode) {
        DEBUG = debugMode;
    }

    public static void v(@NonNull String tag, @NonNull String message) {
        if (DEBUG) {
            logger.v(TAG, "[[" + tag + "]]  " + message);
        }
    }

    public static void v(@NonNull String tag, @NonNull String flowTag, @NonNull String message) {
        if (DEBUG) {
            logger.v(TAG, "[[" + tag + "::" + flowTag + "]]  " + message);
        }
    }

    public static void v(@NonNull String tag, @NonNull String message, @NonNull Throwable exception) {
        if (DEBUG) {
            logger.v(TAG, "[[" + tag + "]]  " + message, exception);
        }
    }

    public static void v(@NonNull String tag, @NonNull String flowTag, @NonNull String message, @NonNull Throwable exception) {
        if (DEBUG) {
            logger.v(TAG, "[[" + tag + "::" + flowTag + "]]  " + message, exception);
        }
    }

    public static void d(@NonNull String tag, @NonNull String message) {
        if (DEBUG) {
            logger.d(TAG, "[[" + tag + "]]  " + message);
        }
    }

    public static void d(@NonNull String tag, @NonNull String flowTag, @NonNull String message) {
        if (DEBUG) {
            logger.d(TAG, "[[" + tag + "::" + flowTag + "]]  " + message);
        }
    }

    public static void d(@NonNull String tag, @NonNull String message, @NonNull Throwable exception) {
        if (DEBUG) {
            logger.d(TAG, "[[" + tag + "]]  " + message, exception);
        }
    }

    public static void d(@NonNull String tag, @NonNull String flowTag, @NonNull String message, @NonNull Throwable exception) {
        if (DEBUG) {
            logger.d(TAG, "[[" + tag + "::" + flowTag + "]]  " + message, exception);
        }
    }

    public static void i(@NonNull String tag, @NonNull String message) {
        if (DEBUG) {
            logger.i(TAG, "[[" + tag + "]]  " + message);
        }
        LPMobileLog.addToLoggos(tag, message, INFO);
    }

    public static void i(@NonNull String tag, @NonNull String flowTag, @NonNull String message) {
        if (DEBUG) {
            logger.i(TAG, "[[" + tag + "::" + flowTag + "]]  " + message);
        }
        LPMobileLog.addToLoggos(tag + "::" + flowTag, message, INFO);
    }

    public static void i(@NonNull String tag, @NonNull String message, @NonNull Throwable exception) {
        if (DEBUG) {
            logger.i(TAG, "[[" + tag + "]]  " + message, exception);
        }
        LPMobileLog.addToLoggos(tag, message + " ** " + LPMobileLog.getStackTrace(exception), INFO);
    }

    public static void i(@NonNull String tag, @NonNull String flowTag, @NonNull String message, @NonNull Throwable exception) {
        if (DEBUG) {
            logger.i(TAG, "[[" + tag + "::" + flowTag + "]]  " + message, exception);
        }
        LPMobileLog.addToLoggos(tag + "::" + flowTag, message + " ** " + LPMobileLog.getStackTrace(exception), INFO);
    }

    public static void w(@NonNull String tag, @NonNull String message) {
        if (DEBUG) {
            logger.w(TAG, "[[" + tag + "]]  " + message);
        }
        LPMobileLog.addToLoggos(tag, message, WARN);
    }

    public static void w(@NonNull String tag, @NonNull String flowTag, @NonNull String message) {
        if (DEBUG) {
            logger.w(TAG, "[[" + tag + "::" + flowTag + "]]  " + message);
        }
        LPMobileLog.addToLoggos(tag + "::" + flowTag, message, WARN);
    }

    public static void w(@NonNull String tag, @NonNull String message, @NonNull Throwable exception) {
        if (DEBUG) {
            logger.w(TAG, "[[" + tag + "]]  " + message, exception);
        }
        LPMobileLog.addToLoggos(tag, message + " ** " + LPMobileLog.getStackTrace(exception), WARN);
    }

    public static void w(@NonNull String tag, @NonNull String flowTag, @NonNull String message, @NonNull Throwable exception) {
        if (DEBUG) {
            logger.w(TAG, "[[" + tag + "::" + flowTag + "]]  " + message, exception);
        }
        LPMobileLog.addToLoggos(tag + "::" + flowTag, message + " ** " + LPMobileLog.getStackTrace(exception), WARN);
    }

    public static void e(@NonNull String tag, @NonNull String message) {
        logger.e(TAG, "[[" + tag + "]]  " + message);
        LPMobileLog.sendToLoggosNow(tag, message, ERROR);
    }

    public static void e(@NonNull String tag, @NonNull String flowTag, @NonNull String message) {
        logger.e(TAG, "[[" + tag + "::" + flowTag + "]]  " + message);
        LPMobileLog.sendToLoggosNow(tag + "::" + flowTag, message, ERROR);
    }

    public static void e(@NonNull String tag, @NonNull String message, @NonNull Throwable exception) {
        logger.e(TAG, "[[" + tag + "]]  " + message, exception);
        LPMobileLog.sendToLoggosNow(tag, message + " ** " + LPMobileLog.getStackTrace(exception), ERROR);
    }

    public static void e(@NonNull String tag, @NonNull String flowTag, @NonNull String message, @NonNull Throwable exception) {
        logger.e(TAG, "[[" + tag + "::" + flowTag + "]]  " + message, exception);
        LPMobileLog.sendToLoggosNow(tag + "::" + flowTag, message + " ** " + LPMobileLog.getStackTrace(exception), ERROR);
    }

    private static String getStackTrace(Throwable aThrowable) {
        if (aThrowable == null) {
            return "";
        }
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static void sendUsageStatistics(String classTAG, String message) {
        if (isLoggosEnabled) {
            LoggosMessage loggosMessage = new LoggosMessage(INFO, LOGGOS_CONTEXT, message, classTAG);
            loggosMessage.setSdkVersion("5.1.0");
            loggosMessage.setIsFeatureStatistics(true);
            Loggos loggos = Infra.instance.getLoggos();
            if (loggos != null) {
                loggos.sendMessageImmediately(loggosMessage);
            }
        }
    }

    private static void addToLoggos(String classTAG, String message, String level) {
        if (isLoggosEnabled) {
            LoggosMessage loggosMessage = new LoggosMessage(level, LOGGOS_CONTEXT, message, classTAG);
            Loggos loggos = Infra.instance.getLoggos();
            if (loggos != null) {
                loggos.addMessage(loggosMessage);
            }
        }
    }

    private static void sendToLoggosNow(String classTAG, String message, String level) {
        if (isLoggosEnabled) {
            LoggosMessage loggosMessage = new LoggosMessage(level, LOGGOS_CONTEXT, message, classTAG);
            Loggos loggos = Infra.instance.getLoggos();
            if (loggos != null) {
                loggos.sendMessageImmediately(loggosMessage);
            }
        }
    }

    public class FlowTags {
        public static final String DIALOGS = "MULTI_DIALOG_FLOW";
        public static final String LOGIN = "LOGIN_FLOW";
        public static final String DECRYPTION = "DECRYPTION";
        public static final String QUICK_REPLIES = "QuickReplies";
    }
}

