package com.liveperson.infra.network;


import java.io.IOException;

/**
 * Back-off policy when retrying an operation.
 * <p/>
 * <p/>
 * Created by ofira on 4/24/16.
 */
public interface BackOff {

    long STOP = -1L;
    long ZERO = 0L;




    /**
     * Indicating that the operation is retried immediately without waiting
     */
    BackOff ZERO_BACKOFF = new BackOff() {

        public void reset() throws IOException {
        }

        public long getNextBackOffMillis() {
            return ZERO;
        }

        public int getRetryNumber() {
            return 0;
        }

        public void calculateNextBackOffMillis() {

        }
    };


    /**
     * Indicating that the operation should not be retried
     */
    BackOff STOP_BACKOFF = new BackOff() {

        public void reset() throws IOException {
        }

        public long getNextBackOffMillis() {
            return STOP;
        }

        public void calculateNextBackOffMillis() {

        }

        public int getRetryNumber() {
            return 0;
        }
    };


    /**
     * Reset the operation
     *
     * @throws IOException
     */
    void reset() throws IOException;


    /**
     * Get the number in milliseconds to wait before retrying the operation
     *
     * @return
     * @throws IOException
     */
    long getNextBackOffMillis();

    void calculateNextBackOffMillis();

    int getRetryNumber();
}