package com.liveperson.infra.network.http.requests;

import android.text.TextUtils;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;

import java.util.List;

/**
 * Created by ofira on 9/17/17.
 */

public class BadgeCounterRequest implements Command {

    private static final String TAG = "BadgeCounterRequest";
    private static final int BADGE_REQUEST_TIMEOUT = 30000;

    private String mPusherURL;
    private String mToken;
    private ICallback<String, Exception> mCallback;
    private List<String> mCertificates;

    public BadgeCounterRequest(String pusherURL, String token, List<String> certificates, ICallback<String, Exception> callback) {
        mPusherURL = pusherURL;
        mToken = token;
        mCallback = callback;
        mCertificates = certificates;
    }

    @Override
    public void execute() {

        HttpGetRequest httpGetRequest = new HttpGetRequest(mPusherURL);
        httpGetRequest.setTimeout(BADGE_REQUEST_TIMEOUT);
        httpGetRequest.addHeader("authorization", "bearer " + mToken);
        httpGetRequest.setCertificatePinningKeys(mCertificates);

        LPMobileLog.i(TAG, "Pusher url " + mPusherURL);

        httpGetRequest.setCallback(new ICallback<String, Exception>() {
            @Override
            public void onSuccess(final String json) {
                if (!TextUtils.isEmpty(json)) {
                    LPMobileLog.i(TAG, "onSuccess " + json);
                    if (mCallback != null) {
                        mCallback.onSuccess(json);
                        return;
                    }
                }
                mCallback.onError(new Exception("Error: empty response from the server"));
            }

            @Override
            public void onError(Exception exception) {
                if (exception != null) {
                    LPMobileLog.e(TAG, "onError ", exception);
                    if (mCallback != null) {
                        mCallback.onError(exception);
                        return;
                    }
                }
                mCallback.onError(new Exception("Error: request failed"));
            }
        });
        HttpHandler.execute(httpGetRequest);
    }
}
