/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.liveperson.infra.Infra;
import java.util.ArrayList;
import java.util.List;

public class LocalBroadcastReceiver {
    private static final String TAG = LocalBroadcastReceiver.class.getSimpleName();
    private IOnReceive mReceiver;
    private LPBroadcastReceiver mLocalBroadcastManager;
    private boolean mSingleCallback;
    private List<String> mIntentFilters;
    private boolean isRegistered;

    public void unregister() {
        this.isRegistered = false;
        this.mLocalBroadcastManager.unregister();
    }

    public void register() {
        this.isRegistered = true;
        this.mLocalBroadcastManager.register();
    }

    private LocalBroadcastReceiver(Builder builder, IOnReceive receiverCallback) {
        this.mSingleCallback = builder.singleCallback;
        this.mIntentFilters = builder.intentFilters;
        this.mReceiver = receiverCallback;
        this.mLocalBroadcastManager = new LPBroadcastReceiver();
        this.register();
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public class LPBroadcastReceiver
    extends BroadcastReceiver {
        private LocalBroadcastManager broadcastManager = LocalBroadcastManager.getInstance((Context)Infra.instance.getApplicationContext());

        public void register() {
            for (String filterKey : LocalBroadcastReceiver.this.mIntentFilters) {
                this.broadcastManager.registerReceiver((BroadcastReceiver)this, new IntentFilter(filterKey));
            }
        }

        public void onReceive(Context context, Intent intent) {
            LocalBroadcastReceiver.this.mReceiver.onBroadcastReceived(context, intent);
            if (LocalBroadcastReceiver.this.mSingleCallback) {
                this.unregister();
            }
        }

        public void unregister() {
            this.broadcastManager.unregisterReceiver((BroadcastReceiver)this);
        }
    }

    public static class Builder {
        private boolean singleCallback;
        private List<String> intentFilters = new ArrayList<String>();

        public Builder addAction(String action) {
            this.intentFilters.add(action);
            return this;
        }

        public Builder setSingleCallback() {
            this.singleCallback = true;
            return this;
        }

        public LocalBroadcastReceiver build(IOnReceive receiverCallback) {
            return new LocalBroadcastReceiver(this, receiverCallback);
        }
    }

    public static interface IOnReceive {
        public void onBroadcastReceived(Context var1, Intent var2);
    }
}

