/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.handler;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.liveperson.infra.R;
import com.liveperson.infra.log.LPMobileLog;

public class NotificationHandler {
    private static final String TAG = NotificationHandler.class.getSimpleName();
    private static final int NOTIFICATION_ID = 1212322;
    private final String mBrandId;
    private final String mTitle;
    private final String mMessage;
    private final Context mContext;
    private int mNotificationDefaults = 5;
    private boolean mAutoCancel = true;
    private int mIconResourceId;
    private Class<?> mStartActivityClass;
    private PendingIntent mPendingIntent;

    public NotificationHandler(String brandId, Context context, Class<?> startActivityClass, String title, String message) {
        this.mContext = context;
        this.mBrandId = brandId;
        this.mStartActivityClass = startActivityClass;
        this.mTitle = title;
        this.mMessage = message;
    }

    public NotificationHandler(String brandId, Context context, Class<?> startActivityClass) {
        this(brandId, context, startActivityClass, null, null);
    }

    public NotificationHandler(Context context, String title) {
        this(null, context, null, title, null);
    }

    public NotificationHandler setIconResourceId(int iconResourceId) {
        this.mIconResourceId = iconResourceId;
        return this;
    }

    public NotificationHandler setPendingIntent(PendingIntent pendingIntent) {
        this.mPendingIntent = pendingIntent;
        return this;
    }

    public NotificationHandler setAutoCancel(boolean autoCancel) {
        this.mAutoCancel = autoCancel;
        return this;
    }

    public NotificationHandler setNotificationDefaults(int defaults) {
        this.mNotificationDefaults = defaults;
        return this;
    }

    public static void hideNotification(Context context, String brandId) {
        ((NotificationManager)context.getSystemService("notification")).cancel(brandId, 1212322);
    }

    public void showNotification() {
        LPMobileLog.i(TAG, "show notification, title = " + this.mTitle);
        Notification notification = this.createPushNotificationBuilder().build();
        this.getNotificationManager().notify(1212322, notification);
    }

    private Notification.Builder createPushNotificationBuilder() {
        String channelId = this.mContext.getString(R.string.push_notification_channel_id);
        String channelName = this.mContext.getString(R.string.push_notification_channel_name);
        Notification.Builder builder = this.createNotificationBuilder(channelId, channelName);
        builder.setContentTitle((CharSequence)this.mTitle).setAutoCancel(this.mAutoCancel).setDefaults(this.mNotificationDefaults).setSmallIcon(this.mIconResourceId).setContentText((CharSequence)this.mMessage);
        if (Build.VERSION.SDK_INT >= 21) {
            builder.setCategory("msg").setPriority(1);
        }
        return builder;
    }

    public Notification.Builder createForegroundServiceNotificationBuilder() {
        String channelId = this.mContext.getString(R.string.foreground_service_notification_channel_id);
        String channelName = this.mContext.getString(R.string.foreground_service_notification_channel_name);
        Notification.Builder builder = this.createNotificationBuilder(channelId, channelName);
        builder = builder.setContentTitle((CharSequence)this.mTitle).setSmallIcon(this.mIconResourceId).setLargeIcon(BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)this.mIconResourceId)).setContentIntent(this.mPendingIntent).setProgress(0, 0, true);
        return builder;
    }

    private Notification.Builder createNotificationBuilder(String channelId, String channelName) {
        Notification.Builder builder;
        if (Build.VERSION.SDK_INT < 26) {
            builder = new Notification.Builder(this.mContext);
        } else {
            this.createNotificationChannel(channelId, channelName);
            builder = new Notification.Builder(this.mContext, channelId);
        }
        return builder;
    }

    @RequiresApi(api=26)
    private void createNotificationChannel(String channelId, String channelName) {
        NotificationChannel notificationChannel = new NotificationChannel(channelId, (CharSequence)channelName, 3);
        this.getNotificationManager().createNotificationChannel(notificationChannel);
    }

    private PendingIntent createPendingIntent(String brand) {
        LPMobileLog.d(TAG, "createPendingIntent with brand " + brand);
        if (this.mStartActivityClass == null || this.mContext == null) {
            LPMobileLog.e(TAG, "createPendingIntent: target class or context not available");
            return null;
        }
        Intent showIntent = new Intent(this.mContext, this.mStartActivityClass);
        showIntent.putExtra("brand_id", brand);
        return PendingIntent.getActivity((Context)this.mContext, (int)10, (Intent)showIntent, (int)0x8000000);
    }

    private NotificationManager getNotificationManager() {
        return (NotificationManager)this.mContext.getSystemService("notification");
    }
}

