/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class DocumentUtils {
    private static final String TAG = "DocumentUtils";
    private static final String DOCUMENTS_FOLDER = "documents/";
    private static final List<String> knownExtensions = Arrays.asList("pdf", "docx", "pptx", "xlsx");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getDocumentSize(Uri uri, Context context) {
        String fileScheme = uri.getScheme();
        if (fileScheme != null && fileScheme.equals("content")) {
            try (Cursor cursor = context.getContentResolver().query(uri, null, null, null, null, null);){
                if (cursor == null || !cursor.moveToFirst()) return 0;
                int sizeIndex = cursor.getColumnIndex("_size");
                if (!cursor.isNull(sizeIndex)) {
                    String size = cursor.getString(sizeIndex);
                    int n = Integer.parseInt(size);
                    return n;
                }
                int n = 0;
                return n;
            }
        } else {
            try {
                File file = new File(uri.getPath());
                int size = (int)file.length();
                LPMobileLog.d(TAG, "File size: " + size);
                return size;
            }
            catch (Exception e) {
                LPMobileLog.e(TAG, "Failed to calculate file size", e);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDocumentName(Uri uri, Context context) {
        block8: {
            String fileScheme = uri.getScheme();
            if (fileScheme != null && fileScheme.equals("content")) {
                try (Cursor cursor = context.getContentResolver().query(uri, null, null, null, null, null);){
                    if (cursor != null && cursor.moveToFirst()) {
                        String displayName = cursor.getString(cursor.getColumnIndex("_display_name"));
                        LPMobileLog.i(TAG, "File Name: " + displayName);
                        String string2 = displayName;
                        return string2;
                    }
                    break block8;
                }
            }
            try {
                File file = new File(uri.getPath());
                return file.getName();
            }
            catch (Exception e) {
                LPMobileLog.e(TAG, "Failed to retrieve file name", e);
            }
        }
        return null;
    }

    public static String saveOriginalDocument(Uri uri, Context context, String brandId, byte[] documentByteArray) {
        String documentName = DocumentUtils.getDocumentName(uri, context);
        String filename = UUID.randomUUID().toString();
        String fileExtension = DocumentUtils.getDocumentExtension(uri, context, documentName);
        if (fileExtension != null) {
            filename = filename + "." + fileExtension;
        }
        LPMobileLog.d(TAG, "new file name: " + filename);
        return DocumentUtils.saveDocumentToDisk(context, filename, brandId, documentByteArray);
    }

    private static String getDocumentExtension(Uri uri, Context context, String documentName) {
        String[] documentNameArray = documentName.split("\\.");
        String extension = documentNameArray[documentNameArray.length - 1];
        if (!TextUtils.isEmpty((CharSequence)extension) && knownExtensions.contains(extension.toLowerCase())) {
            return extension;
        }
        if (!TextUtils.isEmpty((CharSequence)extension)) {
            String mimeType = context.getContentResolver().getType(uri);
            extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
            return extension;
        }
        return null;
    }

    private static String saveDocumentToDisk(Context context, String fileName, String brandId, byte[] documentByteArray) {
        String path = "/documents/" + brandId;
        File filePath = FileUtils.getFilePath(context, path, fileName);
        if (filePath == null) {
            return null;
        }
        return DocumentUtils.saveDocumentToDisk(documentByteArray, filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String saveDocumentToDisk(byte[] documentByteArray, File filePath) {
        LPMobileLog.d(TAG, "saveDocumentToDisk: filePath: " + filePath.getAbsolutePath());
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            fos.write(documentByteArray);
        }
        catch (FileNotFoundException e) {
            LPMobileLog.e(TAG, "saveDocumentToDisk: File not found", e);
            String string2 = null;
            return string2;
        }
        catch (IOException e) {
            LPMobileLog.e(TAG, "saveDocumentToDisk: IOException", e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                LPMobileLog.e(TAG, "saveDocumentToDisk: error closing file", e);
                return null;
            }
        }
        LPMobileLog.d(TAG, "saveDocumentToDisk: file absolute path: " + filePath.getAbsolutePath());
        return filePath.getAbsolutePath();
    }
}

