/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import androidx.annotation.Nullable;
import com.liveperson.infra.log.LPMobileLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileUtils {
    private static final String TAG = "FileUtils";
    private static String IMAGES_FOLDER = "images/";
    private static String VOICE_FOLDER = "voice/";
    private static String DOCUMENTS_FOLDER = "documents/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File privateDirectory, File publicDirectory) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(privateDirectory);
            out = new FileOutputStream(publicDirectory);
            byte[] b = new byte[5120];
            int len = 0;
            while ((len = in.read(b)) > 0) {
                out.write(b, 0, len);
            }
        }
        catch (Exception e) {
            LPMobileLog.e(TAG, "Exception copying file.", e);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LPMobileLog.e(TAG, "Exception closing FileOutputStream", e);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                LPMobileLog.e(TAG, "Exception closing FileOutputStream", e);
            }
        }
        return privateDirectory.getName().equals(publicDirectory.getName());
    }

    @Nullable
    public static File getFilePath(Context context, String path, String filename) {
        File privateDir = new File(context.getApplicationContext().getFilesDir() + path);
        File filePath = new File(privateDir, filename);
        if (!privateDir.exists() && !privateDir.mkdirs()) {
            LPMobileLog.e(TAG, "getFilePath: folder could not be created");
            return null;
        }
        return filePath;
    }

    public static void deleteAllSharedFiles(Context context) {
        LPMobileLog.d(TAG, "deleting all shared files with agent");
        FileUtils.deleteFolder(context, IMAGES_FOLDER);
        FileUtils.deleteFolder(context, VOICE_FOLDER);
        FileUtils.deleteFolder(context, DOCUMENTS_FOLDER);
    }

    private static void deleteFolder(Context context, String folderName) {
        File dirToDelete = new File(context.getFilesDir() + "/" + folderName + "/");
        LPMobileLog.d(TAG, "delete" + folderName + "Folder: Trying to delete the" + folderName + "folder:" + dirToDelete.getAbsolutePath());
        FileUtils.deleteRecursively(dirToDelete);
    }

    private static void deleteRecursively(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            LPMobileLog.d(TAG, "deleteRecursive: deleting directory: " + fileOrDirectory.getAbsolutePath());
            for (File child : fileOrDirectory.listFiles()) {
                LPMobileLog.d(TAG, "deleteRecursive: deleting file: " + child.getAbsolutePath());
                FileUtils.deleteRecursively(child);
            }
        }
        fileOrDirectory.delete();
    }
}

