/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.util.LruCache;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.utils.SourceContent;

public class LinkPreviewLruCache {
    public static final String TAG = LinkPreviewLruCache.class.getSimpleName();
    public static final int DEFAULT_NUM_OF_OBJECTS = 10;
    private static LinkPreviewLruCache INSTANCE;
    private LruCache<String, SourceContent> mLruCache;

    private LinkPreviewLruCache(int numOfObjects) {
        this.mLruCache = new LruCache(numOfObjects);
    }

    public static LinkPreviewLruCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LinkPreviewLruCache(10);
        }
        return INSTANCE;
    }

    public void addSourceContentToCache(String key, SourceContent content) {
        if (this.getSourceContentFromCache(key) == null) {
            LPMobileLog.d(TAG, "cache -- : ADD Key: " + key + " in total: " + this.mLruCache.size());
            this.mLruCache.put((Object)key, (Object)content);
        }
    }

    public SourceContent getSourceContentFromCache(String key) {
        if (this.mLruCache.get((Object)key) != null) {
            LPMobileLog.d(TAG, "cache -- : GET found: " + key + " hit count: " + this.mLruCache.hitCount());
        }
        return (SourceContent)this.mLruCache.get((Object)key);
    }
}

