/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.text.TextUtils;
import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPMobileLog;

public class VersionUtils {
    public static final String TAG = VersionUtils.class.getSimpleName();

    public static boolean isValidSdkVersion(String minSdkVersion) {
        String hostVersion = Infra.instance.getHostVersion();
        if (VersionUtils.versionCompare(hostVersion, minSdkVersion) < 0) {
            LPMobileLog.w(TAG, "isValidSdkVersion: Current SDK version (" + hostVersion + ") is smaller than the one from the server (" + minSdkVersion + "). ");
            return false;
        }
        LPMobileLog.d(TAG, "isValidSdkVersion: Version check is OK");
        return true;
    }

    public static boolean isVersionsEqual(String version1, String version2) {
        return VersionUtils.versionCompare(version1, version2) == 0;
    }

    private static Integer versionCompare(String str1, String str2) throws NullPointerException {
        int i;
        LPMobileLog.d(TAG, "versionCompare str1 " + str1);
        LPMobileLog.d(TAG, "versionCompare str2 " + str2);
        if (TextUtils.isEmpty((CharSequence)str1) || TextUtils.isEmpty((CharSequence)str2)) {
            LPMobileLog.w(TAG, "versionCompare: one of the compared version is null or empty");
            return 0;
        }
        String[] values1 = str1.split("\\.");
        String[] values2 = str2.split("\\.");
        for (i = 0; i < values1.length && i < values2.length && values1[i].equals(values2[i]); ++i) {
        }
        if (i < values1.length && i < values2.length) {
            int diff = Integer.valueOf(values1[i]).compareTo(Integer.valueOf(values2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(values1.length - values2.length);
    }
}

