package com.liveperson.infra.network.http.body;

import org.json.JSONArray;

/**
 * Created by ofira on 12/11/2015.
 */
public class LPJSONArrayBody extends HttpStringRequestBody {

    private static final String CONTENT_TYPE = "application/json";
    private JSONArray mJsonArray;

    public LPJSONArrayBody(JSONArray jsonArray) {
        mJsonArray = jsonArray;
    }

    @Override
    public String get() {
        if (mJsonArray != null) {
            return mJsonArray.toString();
        }
        return "";
    }

    @Override
    public String getContentType() {
        return CONTENT_TYPE;
    }
}
