/* Copyright (c) LivePerson, Inc. */
package com.liveperson.infra.utils;

import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.text.TextUtils;

import java.util.Locale;

/**
 * Created by yanda on 06/28/2019.
 */
public class LocaleUtils {

    private static LocaleUtils instance;
    private String engagementLanguageCode;
    private String language;
    private String country;
    private Locale locale;

    private LocaleUtils() {
    }

    public static LocaleUtils getInstance() {
        if (instance == null) {
            instance = new LocaleUtils();
        }
        return instance;
    }

    public void init(Context context) {
        Resources resources = context.getResources();
        country = resources.getConfiguration().locale.getCountry();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            locale = resources.getConfiguration().getLocales().get(0);
        } else {
            locale = resources.getConfiguration().locale;
        }
        language = getLanguageCode(locale.getLanguage());
    }

    /**
     * This method helps getting the right language ISO code, which suppose to be
     * according to ISO-639-1, BUT, on some devices it still returns the deprecated ISO-639.
     * <BR>
     * Languages codes that are translated in this method:
     * <ul>
     * <li>Hebrew:  IW -> HE
     * <li>Indonesian: IN -> ID
     * <li>Yiddish: JI -> YI
     * </ul>
     *
     * @param languageCode - The language code
     * @return The right code according to ISO-639-1
     */
    private String getLanguageCode(String languageCode) {

        if (languageCode.equalsIgnoreCase("iw")) {
            return "he";
        } else if (languageCode.equalsIgnoreCase("in")) {
            return "id";
        } else if (languageCode.equalsIgnoreCase("ji")) {
            return "yi";
        } else {
            return languageCode;
        }
    }

    public void setEngagementLanguageCode(String engagementLanguageCode) {
        this.engagementLanguageCode = engagementLanguageCode;
    }

    public void clearEngagementLanguageCode() {
        engagementLanguageCode = null;
    }

    /**
     * C4M is to allow the engagement language to control the language of the automatic messages.
     * If accdn provides engagementLanguageCode, return it. Otherwise, return device language.
     */
    public String getLocaleCode() {
        if (!TextUtils.isEmpty(engagementLanguageCode)) {
            return engagementLanguageCode;
        }
        return language + "-" + country;
    }

    public Locale getLocale() {
        return locale;
    }
}
