/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.loggos;

import com.liveperson.infra.analytics.AnalyticsEvent;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.log.LogLevel;
import com.liveperson.infra.log.LogLine;
import com.liveperson.infra.loggos.Loggos;
import com.liveperson.infra.loggos.LoggosMessageFactory;
import com.liveperson.infra.loggos.LoggosUploader;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.utils.LocalBroadcast;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 -2\u00020\u0001:\u0001-B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006J\b\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\tH\u0002J\u0006\u0010\u0016\u001a\u00020\u0013J\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u0019\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\rJ\u000e\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0011J\b\u0010\u001f\u001a\u00020\tH\u0002JB\u0010 \u001a\u00020\u00132\"\u0010!\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\"j\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001`#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020\u0013H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/liveperson/infra/loggos/Loggos;", "", "()V", "brandId", "", "certificates", "", "domain", "enabled", "", "internetCheck", "Lkotlin/Function0;", "logSender", "Lcom/liveperson/infra/loggos/LoggosUploader;", "mLastTimeErrorSent", "", "prefsMgr", "Lcom/liveperson/infra/managers/PreferenceManager;", "init", "", "initializeDependencies", "isAnalyticsEnabled", "reportError", "reportFeatureStatistics", "setEnabled", "setInternetChecker", "netCheck", "setLoggosUploader", "loggosUploader", "setSharedPrefsManager", "preferencesManager", "shouldSendError", "uploadAnalyticsReport", "userProperties", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "analyticsEvents", "Ljava/util/concurrent/LinkedBlockingQueue;", "Lcom/liveperson/infra/analytics/AnalyticsEvent;", "callback", "Lcom/liveperson/infra/loggos/LoggosUploader$Callback;", "uploadNow", "factory", "Lcom/liveperson/infra/loggos/LoggosMessageFactory;", "validateDomainAndBrand", "Companion", "infra_release"})
public class Loggos {
    private boolean enabled;
    private LoggosUploader logSender;
    private PreferenceManager prefsMgr;
    private Function0<Boolean> internetCheck;
    private String brandId = "";
    private String domain = "";
    private List<String> certificates;
    private long mLastTimeErrorSent;
    private static final String TAG = "Loggos";
    private static final String DEFAULT_BRAND_ID_FOR_PREFS = "default_brand";
    private static final String PREFS_KEY_LOGGOS_DOMAIN = "prefs_key_loggos_domain";
    private static final String PREFS_KEY_LOGGOS_BRAND_ID = "prefs_key_loggos_targetid";
    private static final String CERTIFICATE_ERROR_ACTION = "certificate_error_action";
    private static final long NUM_OF_MILLISECONDS_BETWEEN_ERRORS = 100L;
    public static final Companion Companion = new Companion(null);

    public final void init(@NotNull String brandId, @NotNull String domain, @NotNull List<String> certificates) {
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        Intrinsics.checkParameterIsNotNull((Object)domain, (String)"domain");
        Intrinsics.checkParameterIsNotNull(certificates, (String)"certificates");
        this.brandId = brandId;
        this.domain = domain;
        this.certificates = certificates;
        this.initializeDependencies();
        this.validateDomainAndBrand();
        LPLog.INSTANCE.d(TAG, "Saving Loggos domain (" + this.domain + ") and brandId (" + this.brandId + ") to Prefs.");
        PreferenceManager preferenceManager = this.prefsMgr;
        if (preferenceManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prefsMgr");
        }
        preferenceManager.setStringValue(PREFS_KEY_LOGGOS_DOMAIN, DEFAULT_BRAND_ID_FOR_PREFS, this.domain);
        PreferenceManager preferenceManager2 = this.prefsMgr;
        if (preferenceManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prefsMgr");
        }
        preferenceManager2.setStringValue(PREFS_KEY_LOGGOS_BRAND_ID, DEFAULT_BRAND_ID_FOR_PREFS, this.brandId);
        LPLog.INSTANCE.i(TAG, "Loggos initialized successfully.");
    }

    public static /* synthetic */ void init$default(Loggos loggos, String string, String string2, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: init");
        }
        if ((n & 4) != 0) {
            List<String> list2 = Collections.emptyList();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.emptyList()");
            list = list2;
        }
        loggos.init(string, string2, list);
    }

    private final void initializeDependencies() {
        boolean bool$iv = this.logSender != null;
        boolean $i$f$unless = false;
        if (!bool$iv) {
            boolean bl = false;
            this.logSender = new LoggosUploader();
        }
        bool$iv = this.prefsMgr != null;
        $i$f$unless = false;
        if (!bool$iv) {
            boolean bl = false;
            PreferenceManager preferenceManager = PreferenceManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)preferenceManager, (String)"PreferenceManager.getInstance()");
            this.prefsMgr = preferenceManager;
        }
        bool$iv = this.internetCheck != null;
        $i$f$unless = false;
        if (!bool$iv) {
            boolean bl = false;
            this.internetCheck = initializeDependencies.6.1.INSTANCE;
        }
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final void setLoggosUploader(@NotNull LoggosUploader loggosUploader) {
        Intrinsics.checkParameterIsNotNull((Object)loggosUploader, (String)"loggosUploader");
        this.logSender = loggosUploader;
    }

    public final void setInternetChecker(@NotNull Function0<Boolean> netCheck) {
        Intrinsics.checkParameterIsNotNull(netCheck, (String)"netCheck");
        this.internetCheck = netCheck;
    }

    public final void setSharedPrefsManager(@NotNull PreferenceManager preferencesManager) {
        Intrinsics.checkParameterIsNotNull((Object)preferencesManager, (String)"preferencesManager");
        this.prefsMgr = preferencesManager;
    }

    public final void reportFeatureStatistics() {
        if (this.enabled) {
            LoggosMessageFactory factory = new LoggosMessageFactory(this.brandId);
            LPLog.INSTANCE.i(TAG, "Uploading feature use report to Loggos...");
            this.uploadNow(factory);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void uploadAnalyticsReport(@NotNull HashMap<String, Object> userProperties, @NotNull LinkedBlockingQueue<AnalyticsEvent> analyticsEvents, @NotNull LoggosUploader.Callback callback) {
        block8: {
            block5: {
                block7: {
                    block6: {
                        Intrinsics.checkParameterIsNotNull(userProperties, (String)"userProperties");
                        Intrinsics.checkParameterIsNotNull(analyticsEvents, (String)"analyticsEvents");
                        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
                        this.initializeDependencies();
                        if (!this.isAnalyticsEnabled()) break block5;
                        this.validateDomainAndBrand();
                        CharSequence charSequence = this.domain;
                        boolean bl = false;
                        if (charSequence.length() == 0) break block6;
                        charSequence = this.brandId;
                        bl = false;
                        if (!(charSequence.length() == 0)) break block7;
                    }
                    LPLog.INSTANCE.w(TAG, "uploadAnalyticsReport: Cannot upload; Loggos is not initialized.");
                    callback.onError(null, new Throwable("Loggos is not initialized."));
                    return;
                }
                LoggosMessageFactory factory = new LoggosMessageFactory(this.brandId);
                ArrayList analyticsData = new ArrayList();
                Iterable $this$mapTo$iv = analyticsEvents;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void analyticsEvent;
                    AnalyticsEvent analyticsEvent2 = (AnalyticsEvent)item$iv;
                    Collection collection = analyticsData;
                    boolean bl = false;
                    void v0 = analyticsEvent;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"analyticsEvent");
                    JSONObject jSONObject = factory.parseAnalyticsData(userProperties, (AnalyticsEvent)v0);
                    collection.add(jSONObject);
                }
                LPLog.INSTANCE.i(TAG, "uploadAnalyticsReport: Uploading analytics report to Loggos. Total event: " + analyticsData.size());
                LoggosUploader loggosUploader = this.logSender;
                if (loggosUploader == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logSender");
                }
                loggosUploader.sendBulk(this.domain, analyticsData, this.certificates, new LoggosUploader.Callback(callback){
                    final /* synthetic */ LoggosUploader.Callback $callback;

                    public void onSuccess(@Nullable String logId) {
                        this.$callback.onSuccess(logId);
                    }

                    public void onError(@Nullable List<? extends JSONObject> messages, @Nullable Throwable exception) {
                        if (exception instanceof SSLPeerUnverifiedException) {
                            LocalBroadcast.sendBroadcast("certificate_error_action");
                        }
                        this.$callback.onError(messages, exception);
                    }
                    {
                        this.$callback = $captured_local_variable$0;
                    }
                });
                break block8;
            }
            LPLog.INSTANCE.i(TAG, "Analytics is disabled. Do not send data to loggos");
        }
    }

    public final void reportError() {
        if (this.enabled && this.shouldSendError()) {
            LoggosMessageFactory factory = new LoggosMessageFactory(this.brandId);
            LPLog.INSTANCE.i(TAG, "Uploading error report to Loggos...");
            this.uploadNow(factory);
            this.mLastTimeErrorSent = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void uploadNow(LoggosMessageFactory factory) {
        block8: {
            block7: {
                CharSequence charSequence = this.domain;
                boolean bl = false;
                if (charSequence.length() == 0) break block7;
                charSequence = this.brandId;
                bl = false;
                if (!(charSequence.length() == 0)) break block8;
            }
            LPLog.INSTANCE.w(TAG, "Cannot upload; Loggos is not initialized.");
            return;
        }
        Function0<Boolean> function0 = this.internetCheck;
        if (function0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"internetCheck");
        }
        if (!((Boolean)function0.invoke()).booleanValue()) {
            LPLog.INSTANCE.w(TAG, "Cannot upload; no internet.");
            return;
        }
        ArrayList messages = new ArrayList();
        Iterable $this$mapTo$iv = LPLog.INSTANCE.getLogSnapshot(LogLevel.VERBOSE);
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void logLine;
            LogLine logLine2 = (LogLine)item$iv;
            Collection collection = messages;
            boolean bl = false;
            JSONObject jSONObject = factory.convertToJson((LogLine)logLine);
            collection.add(jSONObject);
        }
        LoggosUploader loggosUploader = this.logSender;
        if (loggosUploader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logSender");
        }
        loggosUploader.sendBulk(this.domain, messages, this.certificates, new LoggosUploader.Callback(){

            public void onSuccess(@Nullable String logId) {
            }

            public void onError(@Nullable List<? extends JSONObject> messages, @Nullable Throwable exception) {
                if (exception instanceof SSLPeerUnverifiedException) {
                    LocalBroadcast.sendBroadcast("certificate_error_action");
                }
                LPLog.INSTANCE.w("Loggos", "uploadNow: Failed to upload error report to loggos: " + exception);
            }
        });
    }

    private final void validateDomainAndBrand() {
        CharSequence charSequence = this.domain;
        boolean bl = false;
        if (charSequence.length() == 0) {
            PreferenceManager preferenceManager = this.prefsMgr;
            if (preferenceManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"prefsMgr");
            }
            String string = preferenceManager.getStringValue(PREFS_KEY_LOGGOS_DOMAIN, DEFAULT_BRAND_ID_FOR_PREFS, "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prefsMgr.getStringValue(\u2026T_BRAND_ID_FOR_PREFS, \"\")");
            this.domain = string;
            LPLog.INSTANCE.v(TAG, "validateDomainAndBrand: Got domain from preferences: " + this.domain);
        }
        charSequence = this.brandId;
        bl = false;
        if (charSequence.length() == 0) {
            PreferenceManager preferenceManager = this.prefsMgr;
            if (preferenceManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"prefsMgr");
            }
            String string = preferenceManager.getStringValue(PREFS_KEY_LOGGOS_BRAND_ID, DEFAULT_BRAND_ID_FOR_PREFS, "");
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"prefsMgr.getStringValue(\u2026T_BRAND_ID_FOR_PREFS, \"\")");
            this.brandId = string;
            LPLog.INSTANCE.v(TAG, "validateDomainAndBrand: Got targetId from preferences: " + this.brandId);
        }
    }

    private final boolean shouldSendError() {
        boolean needToSend;
        boolean bl = needToSend = System.currentTimeMillis() - this.mLastTimeErrorSent > 100L;
        if (!needToSend) {
            LPLog.INSTANCE.d(TAG, "Time since last error is less than 100 millis; no need to send to loggos");
        }
        return needToSend;
    }

    private final boolean isAnalyticsEnabled() {
        PreferenceManager preferenceManager = this.prefsMgr;
        if (preferenceManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prefsMgr");
        }
        return preferenceManager.getBooleanValue("site_settings_sdk_analytics_enabled_preference_key", "appLevelPreferences", true);
    }

    public Loggos() {
        List list = Collections.emptyList();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList()");
        this.certificates = list;
    }

    public static final /* synthetic */ LoggosUploader access$getLogSender$p(Loggos $this) {
        LoggosUploader loggosUploader = $this.logSender;
        if (loggosUploader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logSender");
        }
        return loggosUploader;
    }

    public static final /* synthetic */ void access$setLogSender$p(Loggos $this, LoggosUploader loggosUploader) {
        $this.logSender = loggosUploader;
    }

    public static final /* synthetic */ PreferenceManager access$getPrefsMgr$p(Loggos $this) {
        PreferenceManager preferenceManager = $this.prefsMgr;
        if (preferenceManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"prefsMgr");
        }
        return preferenceManager;
    }

    public static final /* synthetic */ void access$setPrefsMgr$p(Loggos $this, PreferenceManager preferenceManager) {
        $this.prefsMgr = preferenceManager;
    }

    public static final /* synthetic */ Function0 access$getInternetCheck$p(Loggos $this) {
        Function0<Boolean> function0 = $this.internetCheck;
        if (function0 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"internetCheck");
        }
        return function0;
    }

    public static final /* synthetic */ void access$setInternetCheck$p(Loggos $this, Function0 function0) {
        $this.internetCheck = function0;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/liveperson/infra/loggos/Loggos$Companion;", "", "()V", "CERTIFICATE_ERROR_ACTION", "", "DEFAULT_BRAND_ID_FOR_PREFS", "NUM_OF_MILLISECONDS_BETWEEN_ERRORS", "", "PREFS_KEY_LOGGOS_BRAND_ID", "PREFS_KEY_LOGGOS_DOMAIN", "TAG", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

