/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.util.LruCache;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.SourceContent;

public class LinkPreviewLruCache {
    private static final String TAG = "LinkPreviewLruCache";
    private static final int DEFAULT_NUM_OF_OBJECTS = 10;
    private static LinkPreviewLruCache INSTANCE;
    private LruCache<String, SourceContent> mLruCache = new LruCache(10);

    private LinkPreviewLruCache() {
    }

    public static LinkPreviewLruCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LinkPreviewLruCache();
        }
        return INSTANCE;
    }

    public void addSourceContentToCache(String key, SourceContent content) {
        if (this.getSourceContentFromCache(key) == null) {
            LPLog.INSTANCE.d(TAG, "cache -- : ADD Key: " + key + " in total: " + this.mLruCache.size());
            this.mLruCache.put((Object)key, (Object)content);
        }
    }

    public SourceContent getSourceContentFromCache(String key) {
        if (this.mLruCache.get((Object)key) != null) {
            LPLog.INSTANCE.d(TAG, "cache -- : GET found: " + key + " hit count: " + this.mLruCache.hitCount());
        }
        return (SourceContent)this.mLruCache.get((Object)key);
    }
}

