package com.liveperson.infra.utils;

import com.liveperson.infra.managers.PreferenceManager;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

/**
 * Created by Ilya Gazman on 11/4/2015.
 *
 * Service for creating application unique ids
 */
public class UniqueID {

    private static final String TAG = "UniqueID";
    private static final String UNIQUE_KEY = "unique_key";
    private static volatile AtomicLong mAtomicLong;
    private static PreferenceManager mPreferenceManager;



    static{
        mPreferenceManager = PreferenceManager.getInstance();
    }



    /**
     * Creates new unique id
     * @return
     */
    public static long getUniqueID() {
        if (mAtomicLong == null) {
            synchronized (UniqueID.class) {
                if (mAtomicLong == null) {
                    long lastUniqueId = mPreferenceManager.getLongValue(UNIQUE_KEY, TAG, 0);
                    mAtomicLong = new AtomicLong(lastUniqueId);
                }
            }
        }
        long l = mAtomicLong.incrementAndGet();
        mPreferenceManager.setLongValue(UNIQUE_KEY, TAG, l);
        return l;
    }


    public static String createUniqueMessageEventId(){
        return UUID.randomUUID().toString();
    }
}
