/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.managers;

import android.content.Context;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.callbacks.AuthCallBack;
import com.liveperson.infra.callbacks.AuthStateSubscription;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.Consumer;
import com.liveperson.infra.model.errors.AuthError;
import com.liveperson.infra.network.http.requests.AuthRequest;
import com.liveperson.infra.preferences.AuthPreferences;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\r\b\u0016\u0018\u0000 52\u00020\u0001:\u000245B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\bH\u0002J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\bH\u0002J\b\u0010 \u001a\u00020!H\u0016J\u0006\u0010\"\u001a\u00020!J\\\u0010#\u001a\u00020\u00172\b\u0010$\u001a\u0004\u0018\u00010%2\b\u0010&\u001a\u0004\u0018\u00010\u00052\b\u0010'\u001a\u0004\u0018\u00010\u00052\u0010\u0010(\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010\u00052\b\u0010+\u001a\u0004\u0018\u00010\u00052\u0006\u0010,\u001a\u00020!2\b\u0010-\u001a\u0004\u0018\u00010\u0011J\u0006\u0010.\u001a\u00020\u0017J\u0006\u0010/\u001a\u00020\u0017J\u0006\u00100\u001a\u00020\u0017J\u0010\u00101\u001a\u00020\u00172\u0006\u00102\u001a\u00020\u0015H\u0016J\u000e\u00103\u001a\u00020!2\u0006\u00102\u001a\u00020\u0015R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/liveperson/infra/managers/ConsumerManager;", "", "appContext", "Landroid/content/Context;", "brandId", "", "(Landroid/content/Context;Ljava/lang/String;)V", "activeConsumer", "Lcom/liveperson/infra/model/Consumer;", "activeRequest", "Lcom/liveperson/infra/network/http/requests/AuthRequest;", "authPrefs", "Lcom/liveperson/infra/preferences/AuthPreferences;", "authState", "Lcom/liveperson/infra/managers/ConsumerManager$AuthState;", "callbacks", "", "Lcom/liveperson/infra/callbacks/AuthCallBack;", "mostRecentError", "Lcom/liveperson/infra/model/errors/AuthError;", "subscriptions", "Lcom/liveperson/infra/callbacks/AuthStateSubscription;", "clearDataAndShutdown", "", "getActiveConsumer", "getCurrentConsumerAuthType", "Lcom/liveperson/infra/auth/LPAuthenticationType;", "handleAuthFailure", "authError", "handleAuthSuccessful", "newConsumer", "handleConsumerChange", "hasActiveConsumer", "", "isAuthenticated", "login", "authParams", "Lcom/liveperson/infra/auth/LPAuthenticationParams;", "idpDomain", "hostVersion", "certs", "", "unAuthConnectorId", "authConnectorId", "performSteUp", "callback", "resetAuthState", "setIsAuthenticated", "shutdown", "subscribeToAuthStateChanges", "subscription", "unsubscribeFromAuthStateChanges", "AuthState", "Companion", "infra_release"})
public class ConsumerManager {
    private AuthState authState;
    private final AuthPreferences authPrefs;
    private Consumer activeConsumer;
    private AuthError mostRecentError;
    private AuthRequest activeRequest;
    private final Set<AuthCallBack> callbacks;
    private final Set<AuthStateSubscription> subscriptions;
    private final Context appContext;
    private final String brandId;
    private static final String TAG = "ConsumerManager";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasActiveConsumer() {
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            boolean bl4 = this.activeConsumer != null;
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Consumer getActiveConsumer() {
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            Consumer consumer = this.activeConsumer;
            return consumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isAuthenticated() {
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            boolean bl4 = this.authState == AuthState.AUTHENTICATED && this.activeConsumer != null;
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetAuthState() {
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            this.authState = AuthState.NOT_AUTHENTICATED;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setIsAuthenticated() {
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            this.authState = AuthState.AUTHENTICATED;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleAuthSuccessful(Consumer newConsumer) {
        LPLog.INSTANCE.i(TAG, "Successfully logged in " + LPLog.INSTANCE.mask(newConsumer));
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            AuthState oldState = this.authState;
            Consumer oldConsumer = this.activeConsumer;
            this.authState = AuthState.AUTHENTICATED;
            this.activeConsumer = newConsumer;
            this.mostRecentError = null;
            this.authPrefs.setCachedConsumer(this.brandId, newConsumer);
            for (AuthStateSubscription subscription : this.subscriptions) {
                subscription.onAuthStateChanged(oldState, this.authState, oldConsumer, newConsumer);
            }
            for (AuthCallBack callback : this.callbacks) {
                callback.onAuthSuccess(newConsumer);
            }
            this.callbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleConsumerChange(Consumer newConsumer) {
        LPLog.INSTANCE.i(TAG, "Encountered unexpected consumerId; performing consumer swap from " + LPLog.INSTANCE.mask(this.activeConsumer) + " to " + LPLog.INSTANCE.mask(newConsumer) + '.');
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            Consumer oldConsumer = this.activeConsumer;
            this.authState = AuthState.AUTHENTICATED;
            this.activeConsumer = newConsumer;
            this.mostRecentError = null;
            this.authPrefs.setCachedConsumer(this.brandId, newConsumer);
            for (AuthStateSubscription subscription : this.subscriptions) {
                subscription.onAuthStateChanged(AuthState.AUTHENTICATED, AuthState.AUTHENTICATED, oldConsumer, newConsumer);
            }
            for (AuthCallBack callback : this.callbacks) {
                Consumer consumer = oldConsumer;
                if (consumer == null) {
                    Intrinsics.throwNpe();
                }
                callback.onConsumerSwitch(consumer, newConsumer);
            }
            this.callbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleAuthFailure(AuthError authError) {
        LPLog.INSTANCE.w(TAG, "Auth failed. Reason: " + authError);
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            AuthState oldState = this.authState;
            Consumer oldConsumer = this.activeConsumer;
            this.authState = AuthState.AUTH_FAILED;
            this.activeConsumer = null;
            this.mostRecentError = authError;
            this.authPrefs.setCachedConsumer(this.brandId, null);
            for (AuthStateSubscription subscription : this.subscriptions) {
                subscription.onAuthStateChanged(oldState, this.authState, oldConsumer, null);
            }
            for (AuthCallBack callback : this.callbacks) {
                callback.onAuthFailed(authError);
            }
            this.callbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void login(@Nullable LPAuthenticationParams authParams, @Nullable String idpDomain, @Nullable String hostVersion, @Nullable List<String> certs, @Nullable String unAuthConnectorId, @Nullable String authConnectorId, boolean performSteUp, @Nullable AuthCallBack callback) {
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            if (this.activeRequest != null) {
                AuthRequest authRequest = this.activeRequest;
                if (authRequest == null) {
                    Intrinsics.throwNpe();
                }
                authRequest.cancelAuth();
                this.activeRequest = null;
            }
            AuthState oldState = this.authState;
            this.authState = AuthState.AUTH_IN_PROGRESS;
            if (callback != null) {
                this.callbacks.add(callback);
            }
            AuthRequest authRequest = this.activeRequest = new AuthRequest(this.appContext, this.brandId, idpDomain, authParams, hostVersion, certs, unAuthConnectorId, authConnectorId, performSteUp, new AuthCallBack(this, callback, idpDomain, authParams, hostVersion, certs, unAuthConnectorId, authConnectorId, performSteUp){
                final /* synthetic */ ConsumerManager this$0;
                final /* synthetic */ AuthCallBack $callback$inlined;
                final /* synthetic */ String $idpDomain$inlined;
                final /* synthetic */ LPAuthenticationParams $authParams$inlined;
                final /* synthetic */ String $hostVersion$inlined;
                final /* synthetic */ List $certs$inlined;
                final /* synthetic */ String $unAuthConnectorId$inlined;
                final /* synthetic */ String $authConnectorId$inlined;
                final /* synthetic */ boolean $performSteUp$inlined;
                {
                    this.this$0 = consumerManager;
                    this.$callback$inlined = authCallBack;
                    this.$idpDomain$inlined = string2;
                    this.$authParams$inlined = lPAuthenticationParams;
                    this.$hostVersion$inlined = string3;
                    this.$certs$inlined = list;
                    this.$unAuthConnectorId$inlined = string4;
                    this.$authConnectorId$inlined = string5;
                    this.$performSteUp$inlined = bl;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public void onAuthSuccess(@NotNull Consumer consumer) {
                    Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
                    var2_2 = this;
                    var3_3 = false;
                    var4_4 = false;
                    synchronized (var2_2) {
                        $i$a$-synchronized-ConsumerManager$login$1$1$onAuthSuccess$1 = false;
                        if (ConsumerManager.access$getActiveConsumer$p(this.this$0) == null) ** GOTO lbl-1000
                        v0 = ConsumerManager.access$getActiveConsumer$p(this.this$0);
                        if (v0 == null) {
                            Intrinsics.throwNpe();
                        }
                        var6_8 = v0.getConsumerId();
                        var7_9 = false;
                        var8_10 = false;
                        if (!(var6_8 == null || var6_8.length() == 0) && Intrinsics.areEqual((Object)ConsumerManager.access$getActiveConsumer$p(this.this$0), (Object)consumer) ^ true) {
                            ConsumerManager.access$handleConsumerChange(this.this$0, consumer);
                        } else lbl-1000:
                        // 2 sources

                        {
                            ConsumerManager.access$handleAuthSuccessful(this.this$0, consumer);
                        }
                        var4_5 = Unit.INSTANCE;
                    }
                }

                public void onConsumerSwitch(@NotNull Consumer oldConsumer, @NotNull Consumer newConsumer) {
                    Intrinsics.checkParameterIsNotNull((Object)oldConsumer, (String)"oldConsumer");
                    Intrinsics.checkParameterIsNotNull((Object)newConsumer, (String)"newConsumer");
                }

                public void onAuthFailed(@NotNull AuthError error) {
                    Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                    ConsumerManager.access$handleAuthFailure(this.this$0, error);
                }
            });
            if (authRequest == null) {
                Intrinsics.throwNpe();
            }
            authRequest.authenticate();
            for (AuthStateSubscription subscription : this.subscriptions) {
                subscription.onAuthStateChanged(oldState, this.authState, this.activeConsumer, this.activeConsumer);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeToAuthStateChanges(@NotNull AuthStateSubscription subscription) {
        Intrinsics.checkParameterIsNotNull((Object)subscription, (String)"subscription");
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            bl2 = this.subscriptions.add(subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unsubscribeFromAuthStateChanges(@NotNull AuthStateSubscription subscription) {
        Intrinsics.checkParameterIsNotNull((Object)subscription, (String)"subscription");
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            boolean bl4 = this.subscriptions.remove(subscription);
            return bl4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void shutdown() {
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            if (this.activeRequest != null) {
                AuthRequest authRequest = this.activeRequest;
                if (authRequest == null) {
                    Intrinsics.throwNpe();
                }
                authRequest.cancelAuth();
            }
            this.activeRequest = null;
            AuthState oldState = this.authState;
            Consumer oldConsumer = this.activeConsumer;
            this.authState = AuthState.NOT_AUTHENTICATED;
            this.activeConsumer = null;
            for (AuthStateSubscription subscription : this.subscriptions) {
                subscription.onAuthStateChanged(oldState, this.authState, oldConsumer, null);
            }
            this.callbacks.clear();
            this.subscriptions.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public final LPAuthenticationType getCurrentConsumerAuthType(@NotNull String brandId) {
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        return this.authPrefs.getCurrentAuthType(brandId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDataAndShutdown() {
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            this.authPrefs.clearAll();
            this.shutdown();
            Unit unit = Unit.INSTANCE;
        }
    }

    public ConsumerManager(@NotNull Context appContext, @NotNull String brandId) {
        Intrinsics.checkParameterIsNotNull((Object)appContext, (String)"appContext");
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        this.appContext = appContext;
        this.brandId = brandId;
        this.authState = AuthState.NOT_AUTHENTICATED;
        this.authPrefs = AuthPreferences.Companion.getInstance(this.appContext);
        this.callbacks = new HashSet();
        this.subscriptions = new HashSet();
        CharSequence charSequence = this.brandId;
        boolean bl = false;
        if (charSequence.length() > 0) {
            this.activeConsumer = this.authPrefs.getCachedConsumer(this.brandId);
        }
    }

    public static final /* synthetic */ Consumer access$getActiveConsumer$p(ConsumerManager $this) {
        return $this.activeConsumer;
    }

    public static final /* synthetic */ void access$setActiveConsumer$p(ConsumerManager $this, Consumer consumer) {
        $this.activeConsumer = consumer;
    }

    public static final /* synthetic */ void access$handleConsumerChange(ConsumerManager $this, Consumer newConsumer) {
        $this.handleConsumerChange(newConsumer);
    }

    public static final /* synthetic */ void access$handleAuthSuccessful(ConsumerManager $this, Consumer newConsumer) {
        $this.handleAuthSuccessful(newConsumer);
    }

    public static final /* synthetic */ void access$handleAuthFailure(ConsumerManager $this, AuthError authError) {
        $this.handleAuthFailure(authError);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/liveperson/infra/managers/ConsumerManager$AuthState;", "", "(Ljava/lang/String;I)V", "NOT_AUTHENTICATED", "AUTH_IN_PROGRESS", "AUTHENTICATED", "AUTH_FAILED", "infra_release"})
    public static final class AuthState
    extends Enum<AuthState> {
        public static final /* enum */ AuthState NOT_AUTHENTICATED;
        public static final /* enum */ AuthState AUTH_IN_PROGRESS;
        public static final /* enum */ AuthState AUTHENTICATED;
        public static final /* enum */ AuthState AUTH_FAILED;
        private static final /* synthetic */ AuthState[] $VALUES;

        static {
            AuthState[] authStateArray = new AuthState[4];
            AuthState[] authStateArray2 = authStateArray;
            authStateArray[0] = NOT_AUTHENTICATED = new AuthState();
            authStateArray[1] = AUTH_IN_PROGRESS = new AuthState();
            authStateArray[2] = AUTHENTICATED = new AuthState();
            authStateArray[3] = AUTH_FAILED = new AuthState();
            $VALUES = authStateArray;
        }

        public static AuthState[] values() {
            return (AuthState[])$VALUES.clone();
        }

        public static AuthState valueOf(String string2) {
            return Enum.valueOf(AuthState.class, string2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/infra/managers/ConsumerManager$Companion;", "", "()V", "TAG", "", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

