/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.socket;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.liveperson.infra.IDisposable;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.SocketConnectionParams;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.ISocketCallbacks;
import com.liveperson.infra.network.socket.ISocketWrapper;
import com.liveperson.infra.network.socket.ResponseMap;
import com.liveperson.infra.network.socket.SocketState;
import com.liveperson.infra.network.socket.SocketStateManager;
import com.liveperson.infra.network.socket.SocketWrapperOK;
import com.liveperson.infra.utils.DispatchQueue;
import java.util.LinkedList;
import java.util.Queue;
import org.json.JSONException;
import org.json.JSONObject;

public class SocketHandler
implements ISocketCallbacks,
IDisposable {
    private static final String TAG = "SocketHandler";
    private static final int CLOSING_TIMEOUT = 5000;
    public static final int PERIODIC_PING_TIME = 20000;
    public static final int CERTIFICATE_ERROR = 1200;
    public static final String REQUESTS_ENDING = "_Requests";
    public static final String RESPONSES_ENDING = "_Requests";
    private DispatchQueueFactory dispatchQueueFactory;
    private SocketStateManagerFactory socketStateManagerFactory;
    private SocketWrapperOKFactory socketWrapperOKFactory;
    private ResponseMap mResponseMap;
    private DispatchQueue mRequestsQueue;
    private DispatchQueue mResponsesQueue;
    private ISocketWrapper mSocketWrapper;
    private SocketStateManager mSocketStateManager;
    private Runnable mClosingRunnable = null;
    private Queue<String> mPendingRequest;

    public SocketHandler(ResponseMap responseMap) {
        this.mResponseMap = responseMap;
        this.mPendingRequest = new LinkedList<String>();
    }

    public void init() {
        this.initFactories();
        this.initVariables();
    }

    void connect(SocketConnectionParams connectionParams) {
        this.mRequestsQueue.postRunnable(() -> this.handleConnect(connectionParams));
    }

    private void handleConnect(SocketConnectionParams connectionParams) {
        if (this.mSocketStateManager == null) {
            LPLog.INSTANCE.d(TAG, "Can't handleConnect. Connection is closed.");
            return;
        }
        SocketState state = this.mSocketStateManager.getState();
        LPLog.INSTANCE.d(TAG, "handleConnect with state " + (Object)((Object)state) + ". ");
        switch (state) {
            case OPEN: {
                this.disconnect();
                break;
            }
            case INIT: 
            case ERROR: 
            case CLOSED: {
                this.openConnection(connectionParams);
                break;
            }
        }
    }

    void disconnect() {
        LPLog.INSTANCE.d(TAG, "disconnect");
        this.mRequestsQueue.postRunnable(() -> this.mSocketWrapper.disconnect());
    }

    SocketStateManager getSocketStateManager() {
        return this.mSocketStateManager;
    }

    private void openConnection(SocketConnectionParams connectionParams) {
        LPLog.INSTANCE.d(TAG, "openConnection");
        this.mSocketWrapper = this.socketWrapperOKFactory.createSocketWrapperOK(this);
        try {
            this.mSocketWrapper.connect(connectionParams);
        }
        catch (IllegalArgumentException ie) {
            LPLog.INSTANCE.d(TAG, "Error: ", ie);
        }
    }

    public void send(String message) {
        this.mRequestsQueue.postRunnable(new SendMessageRunnable(message));
    }

    public void sendPendingMessages() {
        LPLog.INSTANCE.d(TAG, "sendPendingMessages # msg: " + (this.mPendingRequest != null ? this.mPendingRequest.size() : -1));
        while (this.mPendingRequest != null && !this.mPendingRequest.isEmpty()) {
            this.mRequestsQueue.postRunnable(new SendMessageRunnable(this.mPendingRequest.poll()));
        }
    }

    private void addPendingMessage(String message) {
        this.mPendingRequest.add(message);
        LPLog.INSTANCE.d(TAG, "addPendingMessage to list: " + LPLog.INSTANCE.mask(message));
    }

    private void handle(BaseResponseHandler baseResponseHandler, Object valueObject) {
        Object request = baseResponseHandler.getRequest();
        if (request != null) {
            ((BaseSocketRequest)request).dispatchSuccess((Object)valueObject);
        }
        boolean isHandled = baseResponseHandler.handle(valueObject);
        if (request != null && isHandled) {
            this.mResponseMap.onRequestHandled(((BaseSocketRequest)request).getRequestId());
        }
    }

    @Override
    public void onStateChanged(SocketState newState) {
        if (this.mSocketStateManager == null) {
            LPLog.INSTANCE.d(TAG, "Can't change socket state. Connection is closed.");
            return;
        }
        LPLog.INSTANCE.d(TAG, "onStateChanged newState " + newState.name());
        this.mSocketStateManager.setState(newState);
        switch (newState) {
            case CLOSING: {
                this.mClosingRunnable = () -> this.tryFinalizeClosing();
                this.mRequestsQueue.postRunnable(this.mClosingRunnable, 5000L);
                break;
            }
            case CLOSED: {
                if (this.mClosingRunnable != null) {
                    this.mRequestsQueue.removeRunnable(this.mClosingRunnable);
                    this.mClosingRunnable = null;
                }
                this.mResponsesQueue.postRunnable(this::finalizeClosing);
                break;
            }
        }
    }

    private void tryFinalizeClosing() {
        if (this.mSocketStateManager.getState() == SocketState.CLOSING) {
            LPLog.INSTANCE.d(TAG, "onStateChanged timeout expired on state CLOSING. force closing socket. ");
            this.finalizeClosing();
        }
    }

    private void finalizeClosing() {
        if (this.mSocketStateManager == null) {
            LPLog.INSTANCE.d(TAG, "Can't finalizeClosing. Connection is closed.");
            return;
        }
        this.mSocketStateManager.setState(SocketState.CLOSED);
        this.mResponseMap.onSocketClosed();
    }

    @Override
    public void onMessage(final String text) {
        LPLog.INSTANCE.d(TAG, "---------------------onMessage---------------------");
        LPLog.INSTANCE.d(TAG, "text " + text);
        this.mResponsesQueue.postRunnable(new Runnable(){

            @Override
            public void run() {
                this.parseIncomingData();
            }

            private void parseIncomingData() {
                JSONObject jsonObject = null;
                try {
                    jsonObject = new JSONObject(text);
                }
                catch (JSONException e1) {
                    LPLog.INSTANCE.e(SocketHandler.TAG, ErrorCode.ERR_00000045, "Error converting response to json object! should never happened!", e1);
                }
                if (jsonObject == null) {
                    return;
                }
                String messageType = jsonObject.optString("type", "AbstractResponse");
                int requestId = jsonObject.optInt("reqId", -1);
                BaseResponseHandler baseResponseHandler = SocketHandler.this.mResponseMap.getRequestIdHandler(messageType, requestId);
                String expectedType = this.extractExpectedParsingType(baseResponseHandler);
                LPLog.INSTANCE.d("FLOW_RESPONSES_", "extractExpectedParsingType expectedType = " + expectedType + " received messageType = " + messageType);
                if (baseResponseHandler != null && !TextUtils.equals((CharSequence)messageType, (CharSequence)expectedType)) {
                    baseResponseHandler = baseResponseHandler.getResponseByExpectedType(messageType);
                }
                if (baseResponseHandler == null) {
                    LPLog.INSTANCE.d(SocketHandler.TAG, "Lost response:" + messageType + "(" + requestId + ")");
                    LPLog.INSTANCE.i(SocketHandler.TAG, "Got response = " + messageType + ", no response handler");
                } else {
                    Object valueObject = null;
                    try {
                        LPLog.INSTANCE.i(SocketHandler.TAG, "Got response = " + messageType + (baseResponseHandler.getRequest() != null ? " for request " + ((BaseSocketRequest)baseResponseHandler.getRequest()).getRequestName() : ""));
                        valueObject = baseResponseHandler.parse(jsonObject);
                    }
                    catch (Exception e1) {
                        LPLog.INSTANCE.e(SocketHandler.TAG, ErrorCode.ERR_00000046, "Error parsing response!", e1);
                    }
                    if (valueObject == null) {
                        Object request = baseResponseHandler.getRequest();
                        if (request != null) {
                            ((BaseSocketRequest)request).dispatchError();
                        }
                    } else {
                        SocketHandler.this.handle(baseResponseHandler, valueObject);
                    }
                }
            }

            @Nullable
            private String extractExpectedParsingType(BaseResponseHandler baseResponseHandler) {
                if (baseResponseHandler == null) {
                    return null;
                }
                return baseResponseHandler.getAPIResponseType();
            }
        });
    }

    @Override
    public void onDisconnected(String reason, int code) {
        this.mSocketStateManager.disconnected(reason, code);
    }

    @Override
    public void dispose() {
        this.mRequestsQueue.cleanupQueue();
        this.mResponsesQueue.cleanupQueue();
        this.mRequestsQueue.postRunnable(() -> {
            LPLog.INSTANCE.i(TAG, "dispose SocketHandler");
            if (this.mSocketWrapper != null && this.mSocketStateManager != null) {
                this.mSocketStateManager.dispose();
                this.mRequestsQueue.dispose();
                this.mResponsesQueue.dispose();
                this.mRequestsQueue = null;
                this.mResponsesQueue = null;
                this.mSocketStateManager = null;
                this.mSocketWrapper = null;
            }
        });
        this.mPendingRequest.clear();
    }

    private void initVariables() {
        this.mRequestsQueue = this.dispatchQueueFactory.createDispatchQueue("_Requests");
        this.mResponsesQueue = this.dispatchQueueFactory.createDispatchQueue("_Requests");
        this.mSocketStateManager = this.socketStateManagerFactory.createSocketStateManager();
        this.mSocketWrapper = this.socketWrapperOKFactory.createSocketWrapperOK(this);
    }

    private void initFactories() {
        if (this.dispatchQueueFactory == null) {
            this.dispatchQueueFactory = new DispatchQueueFactory();
        }
        if (this.socketStateManagerFactory == null) {
            this.socketStateManagerFactory = new SocketStateManagerFactory();
        }
        if (this.socketWrapperOKFactory == null) {
            this.socketWrapperOKFactory = new SocketWrapperOKFactory();
        }
    }

    @VisibleForTesting
    public DispatchQueueFactory getDispatchQueueFactory() {
        return this.dispatchQueueFactory;
    }

    @VisibleForTesting
    public void setDispatchQueueFactory(DispatchQueueFactory dispatchQueueFactory) {
        this.dispatchQueueFactory = dispatchQueueFactory;
    }

    @VisibleForTesting
    public SocketStateManagerFactory getSocketStateManagerFactory() {
        return this.socketStateManagerFactory;
    }

    @VisibleForTesting
    public void setSocketStateManagerFactory(SocketStateManagerFactory socketStateManagerFactory) {
        this.socketStateManagerFactory = socketStateManagerFactory;
    }

    @VisibleForTesting
    public SocketWrapperOKFactory getSocketWrapperOKFactory() {
        return this.socketWrapperOKFactory;
    }

    @VisibleForTesting
    public void setSocketWrapperOKFactory(SocketWrapperOKFactory socketWrapperOKFactory) {
        this.socketWrapperOKFactory = socketWrapperOKFactory;
    }

    private class SendMessageRunnable
    implements Runnable {
        private final String message;

        SendMessageRunnable(String message) {
            this.message = message;
        }

        @Override
        public void run() {
            SocketState state = SocketHandler.this.mSocketStateManager.getState();
            if (state == SocketState.OPEN) {
                LPLog.INSTANCE.d(SocketHandler.TAG, "Sending data: " + LPLog.INSTANCE.mask(this.message));
                SocketHandler.this.mSocketWrapper.send(this.message);
            } else {
                LPLog.INSTANCE.w(SocketHandler.TAG, "Ignoring message(" + (Object)((Object)SocketHandler.this.mSocketStateManager.getState()) + ") " + LPLog.INSTANCE.mask(this.message));
                SocketHandler.this.addPendingMessage(this.message);
            }
        }
    }

    public static class SocketWrapperOKFactory {
        public SocketWrapperOK createSocketWrapperOK(ISocketCallbacks socketCallbacks) {
            return new SocketWrapperOK(socketCallbacks);
        }
    }

    public static class SocketStateManagerFactory {
        public SocketStateManager createSocketStateManager() {
            return new SocketStateManager();
        }
    }

    public static class DispatchQueueFactory {
        public DispatchQueue createDispatchQueue(String queueName) {
            return new DispatchQueue(SocketHandler.TAG + queueName);
        }
    }
}

