/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.socket;

import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.SocketConnectionParams;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.GeneralResponseHandler;
import com.liveperson.infra.network.socket.ResponseMap;
import com.liveperson.infra.network.socket.SocketHandler;
import com.liveperson.infra.network.socket.SocketState;
import com.liveperson.infra.network.socket.SocketStateManager;
import com.liveperson.infra.network.socket.state.SocketStateListener;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import java.util.HashMap;
import java.util.Map;

public class SocketManager
implements ShutDown {
    private static final String TAG = "SocketManager";
    private final Object mSyncObject = new Object();
    private final ResponseMap mResponseMap = new ResponseMap();
    private Map<String, SocketHandler> mSocketHandlersMap = new HashMap<String, SocketHandler>();
    private SocketHandlerFactory socketHandlerFactory;
    private static volatile SocketManager Instance = null;

    private SocketManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SocketManager getInstance() {
        if (Instance != null) return Instance;
        Class<SocketManager> clazz = SocketManager.class;
        synchronized (SocketManager.class) {
            if (Instance != null) return Instance;
            Instance = new SocketManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return Instance;
        }
    }

    public void connect(SocketConnectionParams connectionParams) {
        if (TextUtils.isEmpty((CharSequence)connectionParams.getUrl())) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000047, "Can't connect to empty url");
            return;
        }
        LPLog.INSTANCE.i(TAG, "connecting to socket");
        SocketHandler socketHandler = this.obtainSocket(connectionParams.getUrl());
        if (socketHandler != null) {
            socketHandler.connect(connectionParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketHandler obtainSocket(String url) {
        if (this.socketHandlerFactory == null) {
            this.socketHandlerFactory = new SocketHandlerFactory();
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000049, "Can't obtain socket! url is empty");
            return null;
        }
        Object object = this.mSyncObject;
        synchronized (object) {
            SocketHandler socketHandler = this.mSocketHandlersMap.get(url);
            if (socketHandler == null) {
                socketHandler = this.socketHandlerFactory.createSocketHandler(this.mResponseMap);
                this.mSocketHandlersMap.put(url, socketHandler);
            }
            return socketHandler;
        }
    }

    public void send(BaseSocketRequest baseSocketRequest) {
        SocketHandler socketHandler = this.getSocketHandler(baseSocketRequest);
        if (socketHandler != null) {
            LPLog.INSTANCE.i(TAG, "Sending request " + baseSocketRequest.getRequestName());
            String data = baseSocketRequest.getData();
            socketHandler.send(data);
        }
    }

    public void sendPendingMessages(BaseSocketRequest baseSocketRequest) {
        SocketHandler socketHandler = this.getSocketHandler(baseSocketRequest);
        if (socketHandler != null) {
            socketHandler.sendPendingMessages();
        }
    }

    private SocketHandler getSocketHandler(BaseSocketRequest baseSocketRequest) {
        if (baseSocketRequest == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000004A, "can't get SocketHandler with null request");
            return null;
        }
        LPLog.INSTANCE.d(TAG, "getSocketHandler req id " + baseSocketRequest.getRequestId());
        BaseResponseHandler responseHandler = baseSocketRequest.getResponseHandler();
        if (responseHandler != null) {
            LPLog.INSTANCE.d(TAG, "getResponseHandler for request " + baseSocketRequest.getRequestId() + " is not null");
            responseHandler.init(baseSocketRequest);
            this.mResponseMap.putRequestIdHandler(baseSocketRequest.getRequestId(), responseHandler);
        }
        return this.obtainSocket(baseSocketRequest.getSocketUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killSocket(String url) {
        LPLog.INSTANCE.d(TAG, "kill socket");
        Object object = this.mSyncObject;
        synchronized (object) {
            SocketHandler socketHandler = this.mSocketHandlersMap.get(url);
            if (socketHandler == null) {
                return;
            }
            socketHandler.disconnect();
            socketHandler.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(String url) {
        LPLog.INSTANCE.d(TAG, "disconnect " + url);
        Object object = this.mSyncObject;
        synchronized (object) {
            SocketHandler socketHandler = this.mSocketHandlersMap.get(url);
            if (socketHandler == null) {
                return;
            }
            socketHandler.disconnect();
        }
    }

    @Override
    public void shutDown() {
        LPLog.INSTANCE.i(TAG, "Shutting down all");
        for (String connectionUrl : this.mSocketHandlersMap.keySet()) {
            this.killSocket(connectionUrl);
        }
        this.mSocketHandlersMap.clear();
        this.mResponseMap.shutDown();
        Instance = null;
    }

    public void registerToSocketState(String url, SocketStateListener callback) {
        SocketHandler socketHandler = this.obtainSocket(url);
        if (socketHandler != null) {
            socketHandler.getSocketStateManager().register(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFromSocketState(String url, SocketStateListener callback) {
        SocketHandler socketHandler;
        Object object = this.mSyncObject;
        synchronized (object) {
            socketHandler = this.mSocketHandlersMap.get(url);
        }
        if (socketHandler != null) {
            socketHandler.getSocketStateManager().unregister(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketState getSocketState(String url) {
        Object object = this.mSyncObject;
        synchronized (object) {
            SocketHandler socketHandler = this.mSocketHandlersMap.get(url);
            if (socketHandler == null) {
                return SocketState.INIT;
            }
            SocketStateManager socketStateManager = socketHandler.getSocketStateManager();
            if (socketStateManager == null) {
                return SocketState.INIT;
            }
            return socketStateManager.getState();
        }
    }

    @VisibleForTesting
    public void putGeneralHandlerMap(GeneralResponseHandler generalResponseHandler) {
        this.mResponseMap.putGeneralHandler(generalResponseHandler);
    }

    @VisibleForTesting
    public SocketHandlerFactory getSocketHandlerFactory() {
        return this.socketHandlerFactory;
    }

    @VisibleForTesting
    public void setSocketHandlerFactory(SocketHandlerFactory socketHandlerFactory) {
        this.socketHandlerFactory = socketHandlerFactory;
    }

    public static class SocketHandlerFactory {
        public SocketHandler createSocketHandler(ResponseMap mResponseMap) {
            SocketHandler socketHandler = new SocketHandler(mResponseMap);
            socketHandler.init();
            return socketHandler;
        }
    }
}

