package com.liveperson.infra.network;


/**
 * Back-off policy when retrying an operation.
 * <p/>
 * <p/>
 * Created by ofira on 4/24/16.
 */
public interface BackOff {

    long STOP = -1L;

    /**
     * Reset the operation
     */
    void reset();


    /**
     * Get the number in milliseconds to wait before retrying the operation
     */
    long getNextBackOffMillis();

    void calculateNextBackOffMillis();

    int getRetryNumber();
}