/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.socket;

import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.infra.network.socket.GeneralResponseHandler;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;

public class ResponseMap
implements ShutDown {
    private static final String TAG = "ResponseMap";
    public static final String RESPONSE_TAG = "FLOW_RESPONSES_";
    private ConcurrentHashMap<Long, BaseResponseHandler> uIDMap = new ConcurrentHashMap();
    private GeneralResponseHandler generalResponseHandler = null;

    public void putRequestIdHandler(long requestId, BaseResponseHandler handler) {
        this.uIDMap.remove(requestId);
        this.uIDMap.put(requestId, handler);
    }

    public void onRequestHandled(long requestId) {
        if (this.uIDMap.containsKey(requestId)) {
            this.uIDMap.remove(requestId);
            LPLog.INSTANCE.d(TAG, "onRequestHandled: " + requestId + ", removing it from map. map = " + LPLog.INSTANCE.mask(Arrays.toString(this.uIDMap.keySet().toArray())));
        } else {
            LPLog.INSTANCE.w(TAG, "onRequestHandled NOT IN MAP! " + requestId + ", map = " + LPLog.INSTANCE.mask(Arrays.toString(this.uIDMap.keySet().toArray())));
        }
    }

    public void onSocketClosed() {
        LPLog.INSTANCE.d(TAG, "onSocketClosed: sending event to all waiting requests. map = " + LPLog.INSTANCE.mask(Arrays.toString(this.uIDMap.keySet().toArray())));
        for (BaseResponseHandler response : this.uIDMap.values()) {
            response.giveUp();
        }
        this.uIDMap.clear();
    }

    public BaseResponseHandler getRequestIdHandler(String messageType, long requestId) {
        BaseResponseHandler baseResponseHandler = this.uIDMap.get(requestId);
        if (baseResponseHandler == null) {
            LPLog.INSTANCE.d("FLOW_RESPONSES_ResponseMap", "Getting general response for message type :" + messageType);
            return this.getGeneralHandler(messageType);
        }
        LPLog.INSTANCE.d("FLOW_RESPONSES_ResponseMap", "Found response in map :" + messageType + " requestId = " + requestId);
        return baseResponseHandler;
    }

    private BaseResponseHandler getGeneralHandler(String messageType) {
        if (this.generalResponseHandler == null) {
            return null;
        }
        return this.generalResponseHandler.createInstance(messageType);
    }

    public void putGeneralHandler(GeneralResponseHandler generalResponseHandler) {
        this.generalResponseHandler = generalResponseHandler;
    }

    @Override
    public void shutDown() {
        this.onSocketClosed();
        this.uIDMap.clear();
    }
}

