/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.ThreadPoolExecutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\rH\u0007J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\rH\u0007J\u0012\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\rH\u0003J$\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0007J$\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u001c\u001a\u0004\u0018\u00010\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/liveperson/infra/utils/FileUtils;", "", "()V", "FILE_DIRS", "", "", "[Ljava/lang/String;", "TAG", "containsFiles", "", "context", "Landroid/content/Context;", "createTestFile", "Ljava/io/File;", "folder", "createTestFiles", "", "quantity", "", "deleteFileAsync", "root", "deleteFilesSync", "deleteRecursively", "fileOrDirectory", "getFilePath", "path", "filename", "writeFileContent", "privateDirectory", "publicDirectory", "Landroid/net/Uri;", "infra_release"})
public final class FileUtils {
    private static final String TAG = "FileUtils";
    private static final String[] FILE_DIRS;
    public static final FileUtils INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @JvmStatic
    public static final boolean writeFileContent(@NotNull Context context, @Nullable File privateDirectory, @Nullable Uri publicDirectory) {
        block18: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            inputStream = null;
            parcelFileDescriptor = null;
            fileOutputStream = null;
            try {
                inputStream = new FileInputStream(privateDirectory);
                v0 = publicDirectory;
                if (v0 != null) {
                    var6_6 = v0;
                    var7_10 = false;
                    var8_14 = 0;
                    it = var6_6;
                    $i$a$-let-FileUtils$writeFileContent$1 = false;
                    v1 = context.getContentResolver().openFileDescriptor(it, "w");
                } else {
                    v1 = null;
                }
                v2 = parcelFileDescriptor = v1;
                fileOutputStream = new FileOutputStream(v2 != null ? v2.getFileDescriptor() : null);
                b = new byte[5120];
                len = new Ref.IntRef();
                while (true) {
                    var8_14 = inputStream.read(b);
                    var9_17 = false;
                    var10_18 = false;
                    it = var8_14;
                    $i$a$-also-FileUtils$writeFileContent$2 = false;
                    len.element = it;
                    if (var8_14 <= 0) break;
                    fileOutputStream.write(b, 0, len.element);
                }
                ** try [egrp 1[TRYBLOCK] [0 : 159->185)] { 
            }
            catch (Exception e) {
                LPLog.INSTANCE.e("FileUtils", ErrorCode.ERR_00000012, "Failed to copy file from privateDir to publicDir. ", e);
                len = false;
                return len;
            }
            finally {
                try {
                    v4 = inputStream;
                    if (v4 != null) {
                        v4.close();
                    }
                    v5 = fileOutputStream;
                    if (v5 != null) {
                        v5.close();
                    }
                    v6 = parcelFileDescriptor;
                    if (v6 != null) {
                        v6.close();
                    }
                }
                catch (IOException exception) {
                    LPLog.INSTANCE.e("FileUtils", ErrorCode.ERR_00000013, "Failed to close fileOutputStream/parcelFileDescriptor ", exception);
                }
            }
lbl-1000:
            // 1 sources

            {
                inputStream.close();
                fileOutputStream.close();
                v3 = parcelFileDescriptor;
                if (v3 != null) {
                    v3.close();
                }
                break block18;
            }
lbl40:
            // 1 sources

            catch (IOException exception) {
                LPLog.INSTANCE.e("FileUtils", ErrorCode.ERR_00000013, "Failed to close fileOutputStream/parcelFileDescriptor ", exception);
            }
            {
            }
        }
        return true;
    }

    @JvmStatic
    @Nullable
    public static final File getFilePath(@NotNull Context context, @NotNull String path, @Nullable String filename) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        StringBuilder stringBuilder = new StringBuilder();
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        File privateDir = new File(stringBuilder.append(context2.getFilesDir().toString()).append(path).toString());
        File filePath = new File(privateDir, filename);
        if (!privateDir.exists() && !privateDir.mkdirs()) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000014, "getFilePath: folder could not be created");
            return null;
        }
        return filePath;
    }

    @JvmStatic
    public static final void deleteFilesSync(@NotNull File root) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        String path = root.getPath();
        try {
            String[] $this$forEach$iv = FILE_DIRS;
            boolean $i$f$forEach = false;
            String[] stringArray = $this$forEach$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl = false;
                FilesKt.deleteRecursively((File)new File(path + it));
            }
        }
        catch (IOException ex) {
            String[] $this$forEach$iv = FILE_DIRS;
            boolean $i$f$forEach = false;
            String[] stringArray = $this$forEach$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl = false;
                FileUtils.deleteRecursively(new File(path + it));
            }
        }
    }

    @JvmStatic
    public static final void deleteFileAsync(@NotNull File root) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        ThreadPoolExecutor.execute(new Runnable(root){
            final /* synthetic */ File $root;

            public final void run() {
                FileUtils.deleteFilesSync(this.$root);
            }
            {
                this.$root = file;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @VisibleForTesting
    public static final boolean containsFiles(@NotNull Context context) {
        void $this$fold$iv;
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        File file = context.getFilesDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.filesDir");
        String path = file.getPath();
        Object $this$map$iv = FILE_DIRS;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((String[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        void var7_10 = $this$mapTo$iv$iv;
        int n = ((void)var7_10).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_15 = item$iv$iv = var7_10[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Boolean bl2 = new File(path + (String)it).exists();
            collection.add(bl2);
        }
        $this$map$iv = (List)destination$iv$iv;
        int initial$iv = 0;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void current;
            n = ((Boolean)element$iv).booleanValue() ? 1 : 0;
            int prev = accumulator$iv;
            boolean bl = false;
            accumulator$iv = prev | current;
        }
        return accumulator$iv != 0;
    }

    @JvmStatic
    @VisibleForTesting
    public static final void createTestFiles(@NotNull Context context, int quantity) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        File file = context.getFilesDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.filesDir");
        String path = file.getPath();
        String[] $this$forEach$iv = FILE_DIRS;
        boolean $i$f$forEach = false;
        String[] stringArray = $this$forEach$iv;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String dir = element$iv = stringArray[i];
            boolean bl = false;
            File file2 = new File(path + dir);
            boolean bl2 = false;
            int n2 = 0;
            File it = file2;
            boolean bl3 = false;
            if (!it.exists()) {
                it.mkdirs();
            }
            File folder = file2;
            int n3 = quantity;
            bl2 = false;
            n2 = 0;
            n2 = 0;
            int n4 = n3;
            while (n2 < n4) {
                int it2 = n2++;
                boolean bl4 = false;
                FileUtils.createTestFile(folder);
            }
        }
    }

    @JvmStatic
    @VisibleForTesting
    @NotNull
    public static final File createTestFile(@NotNull File folder) {
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        String name = System.currentTimeMillis() + ".tmp";
        File file = new File(folder, name);
        boolean bl = false;
        boolean bl2 = false;
        File it = file;
        boolean bl3 = false;
        boolean cfr_ignored_0 = it.exists() | it.createNewFile();
        return file;
    }

    @JvmStatic
    private static final void deleteRecursively(File fileOrDirectory) {
        if (fileOrDirectory == null) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000143, "file path is null");
            return;
        }
        if (fileOrDirectory.isDirectory()) {
            LPLog.INSTANCE.d(TAG, "deleteRecursive: deleting directory: " + fileOrDirectory.getAbsolutePath());
            File[] listFiles = fileOrDirectory.listFiles();
            if (listFiles == null) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000144, "File list is null");
                return;
            }
            for (File child : fileOrDirectory.listFiles()) {
                StringBuilder stringBuilder = new StringBuilder().append("deleteRecursive: deleting file: ");
                File file = child;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"child");
                LPLog.INSTANCE.d(TAG, stringBuilder.append(file.getAbsolutePath()).toString());
                FileUtils.deleteRecursively(child);
            }
        }
        fileOrDirectory.delete();
    }

    private FileUtils() {
    }

    static {
        FileUtils fileUtils;
        INSTANCE = fileUtils = new FileUtils();
        FILE_DIRS = new String[]{"/images", "/voice", "/documents"};
    }
}

