/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.controller;

import android.content.ContentValues;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.controller.DBEncryptionService;
import com.liveperson.infra.database.transaction_helper.InsertOrUpdateSQLCommand;
import com.liveperson.infra.database.transaction_helper.InsertSQLCommand;
import com.liveperson.infra.database.transaction_helper.SQLiteCommand;
import com.liveperson.infra.database.transaction_helper.UpdateSQLCommand;
import com.liveperson.infra.utils.EncryptionVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"encrypt", "Landroid/content/ContentValues;", "messageValues", "encryptTransactionData", "", "command", "Lcom/liveperson/infra/database/transaction_helper/SQLiteCommand;", "infra_release"})
public final class DBEncryptionServiceUtilsKt {
    @Nullable
    public static final ContentValues encrypt(@NotNull ContentValues messageValues) {
        String metadata;
        Intrinsics.checkParameterIsNotNull((Object)messageValues, (String)"messageValues");
        EncryptionVersion messageEncryptionVersion = DBEncryptionService.Companion.getAppEncryptionVersion();
        messageValues.put("encryptVer", Integer.valueOf(messageEncryptionVersion.ordinal()));
        String message = messageValues.getAsString("text");
        if (message != null) {
            String encryptedMessage = DBEncryptionHelper.encrypt(messageEncryptionVersion, message);
            messageValues.put("text", encryptedMessage);
        }
        if ((metadata = messageValues.getAsString("metadata")) != null) {
            String encryptedMetadata = DBEncryptionHelper.encrypt(messageEncryptionVersion, metadata);
            messageValues.put("metadata", encryptedMetadata);
        }
        return messageValues;
    }

    public static final void encryptTransactionData(@NotNull SQLiteCommand command) {
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        switch (command.getType()) {
            case 0: {
                InsertSQLCommand insertSQLCommand;
                SQLiteCommand sQLiteCommand = command;
                if (!(sQLiteCommand instanceof InsertSQLCommand)) {
                    sQLiteCommand = null;
                }
                if ((insertSQLCommand = (InsertSQLCommand)sQLiteCommand) != null && (insertSQLCommand = insertSQLCommand.getContentValues()) != null) {
                    InsertSQLCommand insertSQLCommand2 = insertSQLCommand;
                    boolean bl = false;
                    boolean bl2 = false;
                    InsertSQLCommand it = insertSQLCommand2;
                    boolean bl3 = false;
                    DBEncryptionServiceUtilsKt.encrypt((ContentValues)it);
                }
                break;
            }
            case 1: {
                UpdateSQLCommand updateSQLCommand;
                SQLiteCommand sQLiteCommand = command;
                if (!(sQLiteCommand instanceof UpdateSQLCommand)) {
                    sQLiteCommand = null;
                }
                if ((updateSQLCommand = (UpdateSQLCommand)sQLiteCommand) != null && (updateSQLCommand = updateSQLCommand.getContentValues()) != null) {
                    UpdateSQLCommand updateSQLCommand2 = updateSQLCommand;
                    boolean bl = false;
                    boolean bl4 = false;
                    UpdateSQLCommand it = updateSQLCommand2;
                    boolean bl5 = false;
                    DBEncryptionServiceUtilsKt.encrypt((ContentValues)it);
                }
                break;
            }
            case 2: {
                InsertOrUpdateSQLCommand insertOrUpdateSQLCommand;
                InsertOrUpdateSQLCommand it;
                boolean bl;
                boolean bl6;
                InsertOrUpdateSQLCommand insertOrUpdateSQLCommand2;
                InsertOrUpdateSQLCommand currentCommand;
                InsertOrUpdateSQLCommand insertOrUpdateSQLCommand3;
                SQLiteCommand sQLiteCommand = command;
                if (!(sQLiteCommand instanceof InsertOrUpdateSQLCommand)) {
                    sQLiteCommand = null;
                }
                if ((insertOrUpdateSQLCommand3 = (currentCommand = (InsertOrUpdateSQLCommand)sQLiteCommand)) != null && (insertOrUpdateSQLCommand3 = insertOrUpdateSQLCommand3.getContentValuesForInsert()) != null) {
                    insertOrUpdateSQLCommand2 = insertOrUpdateSQLCommand3;
                    bl6 = false;
                    bl = false;
                    it = insertOrUpdateSQLCommand2;
                    boolean bl7 = false;
                    DBEncryptionServiceUtilsKt.encrypt((ContentValues)it);
                }
                if ((insertOrUpdateSQLCommand = currentCommand) != null && (insertOrUpdateSQLCommand = insertOrUpdateSQLCommand.getContentValuesForUpdate()) != null) {
                    insertOrUpdateSQLCommand2 = insertOrUpdateSQLCommand;
                    bl6 = false;
                    bl = false;
                    it = insertOrUpdateSQLCommand2;
                    boolean bl8 = false;
                    DBEncryptionServiceUtilsKt.encrypt((ContentValues)it);
                }
                break;
            }
        }
    }
}

