/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.database;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.database.tables.BaseTable;
import com.liveperson.infra.database.tables.BrandProfileTable;
import com.liveperson.infra.database.tables.ConversationsTable;
import com.liveperson.infra.database.tables.DialogsTable;
import com.liveperson.infra.database.tables.FilesTable;
import com.liveperson.infra.database.tables.MessagesTable;
import com.liveperson.infra.database.tables.UsersTable;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import java.util.ArrayList;
import java.util.List;

public class DatabaseManager
implements ShutDown,
Clearable {
    private static final String TAG = "DatabaseManager";
    private static final String DATABASE_NAME = "lp_infra_tables.db";
    private static final String SQLITE_SEQUENCE_TABLE_NAME = "sqlite_sequence";
    private static final String ANDROID_METADATA_TABLE_NAME = "android_metadata";
    private static final int DATABASE_VERSION = 7;
    private DatabaseHelper mDBHelper;
    private static DatabaseManager mInstance = null;
    private List<BaseTable> tableList = new ArrayList<BaseTable>();

    private DatabaseManager() {
        this.mDBHelper = new DatabaseHelper();
        MessagesTable mMessagesTable = new MessagesTable();
        DialogsTable mDialogsTable = new DialogsTable();
        ConversationsTable mConversationsTable = new ConversationsTable();
        BrandProfileTable brandProfileTable = new BrandProfileTable();
        UsersTable mUsersTable = new UsersTable();
        FilesTable mFilesTable = new FilesTable();
        this.registerTable(mMessagesTable);
        this.registerTable(mDialogsTable);
        this.registerTable(mConversationsTable);
        this.registerTable(brandProfileTable);
        this.registerTable(mUsersTable);
        this.registerTable(mFilesTable);
        this.mDBHelper.getWritableDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatabaseManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<DatabaseManager> clazz = DatabaseManager.class;
        synchronized (DatabaseManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new DatabaseManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    DatabaseHelper getDBHelper() {
        return this.mDBHelper;
    }

    @VisibleForTesting
    void setDBHelper(DatabaseHelper databaseHelper) {
        this.mDBHelper = databaseHelper;
    }

    @VisibleForTesting
    DatabaseManager getDatabaseManagerInstance() {
        return mInstance;
    }

    private void registerTable(@NonNull BaseTable table) {
        this.tableList.add(table);
    }

    @Override
    public void clear() {
        LPLog.INSTANCE.d(TAG, "removing db");
        Infra.instance.getApplicationContext().deleteDatabase(DATABASE_NAME);
        mInstance = null;
    }

    public void deleteTables() {
        LPLog.INSTANCE.d(TAG, "deleting db");
        for (BaseTable table : this.tableList) {
            this.mDBHelper.getWritableDatabase().delete(table.getTableName(), null, new String[0]);
        }
        this.mDBHelper.getWritableDatabase().delete(SQLITE_SEQUENCE_TABLE_NAME, null, new String[0]);
        this.mDBHelper.getWritableDatabase().delete(ANDROID_METADATA_TABLE_NAME, null, new String[0]);
    }

    @Override
    public void shutDown() {
        DataBaseExecutor.killAll(new ICallback<Void, Exception>(){

            @Override
            public void onSuccess(Void value) {
                DatabaseManager.this.mDBHelper.close();
                LPLog.INSTANCE.i(DatabaseManager.TAG, "closed db.");
            }

            @Override
            public void onError(Exception exception) {
                DatabaseManager.this.mDBHelper.close();
                LPLog.INSTANCE.i(DatabaseManager.TAG, "closed db.");
            }
        });
    }

    public class DatabaseHelper
    extends SQLiteOpenHelper {
        private final String TAG = "DatabaseHelper";

        @VisibleForTesting
        public DatabaseHelper() {
            super(Infra.instance.getApplicationContext(), DatabaseManager.DATABASE_NAME, null, 7);
            this.TAG = "DatabaseHelper";
            LPLog.INSTANCE.i("DatabaseHelper", "initializing db...");
        }

        public void onCreate(SQLiteDatabase db) {
            for (BaseTable table : DatabaseManager.this.tableList) {
                LPLog.INSTANCE.d("DatabaseHelper", "Creating table " + table.getName());
                db.execSQL(table.getCreateCommand());
            }
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            LPLog.INSTANCE.d("DatabaseHelper", "Upgrading DB oldVersion = " + oldVersion + " newVersion = " + newVersion);
            for (BaseTable table : DatabaseManager.this.tableList) {
                LPLog.INSTANCE.d("DatabaseHelper", "Upgrading table " + table.getName());
                table.onTableUpgrade(db, oldVersion, newVersion);
            }
        }
    }
}

