/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.requests;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.callbacks.AuthCallBack;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.Consumer;
import com.liveperson.infra.model.errors.AuthError;
import com.liveperson.infra.model.types.AuthFailureReason;
import com.liveperson.infra.network.http.HttpException;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.body.LPJSONObjectBody;
import com.liveperson.infra.network.http.request.HttpPostRequest;
import com.liveperson.infra.network.http.requests.AuthRequest$WhenMappings;
import com.liveperson.infra.preferences.AuthPreferences;
import com.liveperson.infra.utils.TokenUtils;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 52\u00020\u0001:\u00015Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\u0010\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0006\u0010\u001f\u001a\u00020\u001cJ\u0006\u0010 \u001a\u00020\u001cJ\u0014\u0010!\u001a\u0004\u0018\u00010\u00052\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\n\u0010$\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u0010%\u001a\u0004\u0018\u00010\u001e2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0014\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\n\u0010(\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010)\u001a\u00020\u001c2\b\u0010*\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010+\u001a\u00020\u001c2\u000e\u0010,\u001a\n\u0018\u00010-j\u0004\u0018\u0001`.H\u0002J\u001c\u0010/\u001a\u00020\u001c2\b\u0010,\u001a\u0004\u0018\u00010-2\b\u00100\u001a\u0004\u0018\u000101H\u0002J\u0012\u00102\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0012\u00103\u001a\u00020\u001c2\b\u0010*\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u00104\u001a\u00020\u001c2\b\u0010*\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00066"}, d2={"Lcom/liveperson/infra/network/http/requests/AuthRequest;", "", "applicationContext", "Landroid/content/Context;", "brandId", "", "idpDomain", "lpAuthenticationParams", "Lcom/liveperson/infra/auth/LPAuthenticationParams;", "hostVersion", "certificates", "", "unAuthConnectorId", "authConnectorId", "performSteUp", "", "authCallBack", "Lcom/liveperson/infra/callbacks/AuthCallBack;", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Lcom/liveperson/infra/auth/LPAuthenticationParams;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;ZLcom/liveperson/infra/callbacks/AuthCallBack;)V", "isAnonymousRequest", "refreshUnAuthTokenForStepUp", "shouldCancelAuth", "internalCode", "", "Lcom/liveperson/infra/network/http/HttpException;", "getInternalCode", "(Lcom/liveperson/infra/network/http/HttpException;)Ljava/lang/Integer;", "addHeaders", "", "httpPostRequest", "Lcom/liveperson/infra/network/http/request/HttpPostRequest;", "authenticate", "cancelAuth", "generateIdpRequestUrl", "authType", "Lcom/liveperson/infra/auth/LPAuthenticationType;", "getAuthToken", "getHttpPostRequest", "getRequestBody", "Lorg/json/JSONObject;", "getUnAuthToken", "handleSuccess", "token", "refreshUnAuthTokenOnFailure", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "sendErrorCallback", "authFailureReason", "Lcom/liveperson/infra/model/types/AuthFailureReason;", "sendGeneralRequest", "setAuthToken", "setUnAuthToken", "Companion", "infra_release"})
public final class AuthRequest {
    private boolean shouldCancelAuth;
    private boolean isAnonymousRequest;
    private boolean refreshUnAuthTokenForStepUp;
    private final Context applicationContext;
    private final String brandId;
    private final String idpDomain;
    private final LPAuthenticationParams lpAuthenticationParams;
    private final String hostVersion;
    private final List<String> certificates;
    private final String unAuthConnectorId;
    private final String authConnectorId;
    private final boolean performSteUp;
    private final AuthCallBack authCallBack;
    private static final String TAG = "AuthRequest";
    private static final int IDP_TOKEN_EXPIRED = 1012;
    private static final int IDP_REQUEST_TIMEOUT = 30000;
    private static final int NETWORK_READ_TIMEOUT_ERROR_CODE = 598;
    private static final int NETWORK_CONNECT_TIMEOUT_ERROR_CODE = 599;
    private static final int UN_AUTHORIZED_ERROR_CODE = 401;
    private static final String USER_EXPIRED_ERROR = "2001";
    private static final String KEY_LP_JWT = "lp_jwt";
    private static final String KEY_CODE = "code";
    private static final String KEY_REDIRECT_URI = "redirect_uri";
    private static final String KEY_ID_TOKEN = "id_token";
    private static final String SIGNUP = "signup";
    private static final String AUTHENTICATE = "authenticate";
    private static final String DEFAULT_REDIRECT_URI = "https://liveperson.net";
    private static final String IDP_SIGNUP_URL = "https://%s/api/account/%s/%s?v=1.0";
    private static final String IDP_AUTH_URL = "https://%s/api/account/%s/app/default/%s?v=2.0";
    private static final String IDP_ANONYMOUS_URL = "https://%s/api/account/%s/anonymous/authorize";
    private static final String IDP_UN_AUTH_URL = "https://%s/api/account/%s/app/%s/%s?v=3.0";
    public static final Companion Companion = new Companion(null);

    /*
     * Unable to fully structure code
     */
    public final void authenticate() {
        authType = LPAuthenticationType.UN_AUTH;
        this.shouldCancelAuth = false;
        if (this.lpAuthenticationParams != null) {
            authType = this.lpAuthenticationParams.getAuthType();
        }
        v0 = authType;
        if (v0 == null) ** GOTO lbl-1000
        switch (AuthRequest$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                if (!this.performSteUp) break;
                var2_2 = this.getAuthToken();
                var3_3 = false;
                var4_4 = false;
                if (!(var2_2 == null || var2_2.length() == 0)) break;
                this.refreshUnAuthTokenOnFailure(new Exception("Missing authentication token."));
                return;
            }
            case 2: {
                this.isAnonymousRequest = true;
                break;
            }
            case 3: {
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                LPLog.INSTANCE.e("AuthRequest", ErrorCode.ERR_0000013B, "authenticate: Unknown authentication type found: " + (Object)authType + '.');
                this.sendErrorCallback(new Exception("authenticate: Unknown authentication type found: " + (Object)authType + '.'), AuthFailureReason.AUTH_INVALID);
                return;
            }
        }
        LPLog.INSTANCE.i("AuthRequest", "authenticate: Send request to authenticate. Consumer type: " + (Object)authType);
        this.sendGeneralRequest(this.getHttpPostRequest(authType));
    }

    private final HttpPostRequest getHttpPostRequest(LPAuthenticationType authType) {
        HttpPostRequest httpPostRequest = new HttpPostRequest(this.generateIdpRequestUrl(authType));
        JSONObject jsonBody = this.getRequestBody(authType);
        if (jsonBody != null) {
            HttpRequestBody body = new LPJSONObjectBody(jsonBody);
            httpPostRequest.setBody(body);
        } else if (authType == LPAuthenticationType.AUTH) {
            return null;
        }
        httpPostRequest.setCallback(new ICallback<String, Exception>(this, authType, httpPostRequest){
            final /* synthetic */ AuthRequest this$0;
            final /* synthetic */ LPAuthenticationType $authType;
            final /* synthetic */ HttpPostRequest $httpPostRequest;

            /*
             * Unable to fully structure code
             */
            public void onSuccess(@Nullable String idpResponse) {
                block7: {
                    LPLog.INSTANCE.d("AuthRequest", "onSuccess " + LPLog.INSTANCE.mask(idpResponse));
                    if (TextUtils.isEmpty((CharSequence)idpResponse)) break block7;
                    try {
                        idpJson = new JSONObject(idpResponse);
                        token = null;
                        v0 = this.$authType;
                        if (v0 == null) ** GOTO lbl-1000
                        switch (AuthRequest$WhenMappings.$EnumSwitchMapping$1[v0.ordinal()]) {
                            case 1: {
                                token = idpJson.getString("token");
                                break;
                            }
                            case 2: {
                                token = idpJson.getString("token");
                                if (AuthRequest.access$isAnonymousRequest$p(this.this$0)) {
                                    AuthRequest.access$setAnonymousRequest$p(this.this$0, false);
                                    AuthRequest.access$setUnAuthToken(this.this$0, token);
                                    AuthRequest.access$sendGeneralRequest(this.this$0, AuthRequest.access$getHttpPostRequest(this.this$0, this.$authType));
                                    return;
                                }
                                if (!AuthRequest.access$getRefreshUnAuthTokenForStepUp$p(this.this$0)) break;
                                AuthRequest.access$setRefreshUnAuthTokenForStepUp$p(this.this$0, false);
                                AuthRequest.access$setAuthToken(this.this$0, token);
                                AuthRequest.access$sendGeneralRequest(this.this$0, AuthRequest.access$getHttpPostRequest(this.this$0, LPAuthenticationType.AUTH));
                                return;
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                token = idpJson.getString("jwt");
                            }
                        }
                        AuthRequest.access$handleSuccess(this.this$0, token);
                    }
                    catch (Exception exception) {
                        LPLog.INSTANCE.e("AuthRequest", ErrorCode.ERR_0000013C, "getHttpPostRequest: Failed to parse response: ", exception);
                        AuthRequest.access$setAnonymousRequest$p(this.this$0, false);
                        AuthRequest.access$sendErrorCallback(this.this$0, new Exception("getHttpPostRequest: Failed to parse response"), AuthFailureReason.CLIENT);
                    }
                }
            }

            public void onError(@Nullable Exception exception) {
                LPLog.INSTANCE.d("AuthRequest", "Error: idp url = " + this.$httpPostRequest.getUrl() + ". Exception ", exception);
                if (exception != null && this.$authType == LPAuthenticationType.UN_AUTH) {
                    AuthRequest.access$setAnonymousRequest$p(this.this$0, false);
                    String message = exception.getMessage();
                    if (!TextUtils.isEmpty((CharSequence)message)) {
                        String string2 = message;
                        if (string2 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"2001", (boolean)false, (int)2, null) && !TextUtils.isEmpty((CharSequence)AuthRequest.access$getUnAuthToken(this.this$0))) {
                            AuthRequest.access$setUnAuthToken(this.this$0, "");
                            AuthRequest.access$sendErrorCallback(this.this$0, exception, AuthFailureReason.USER_EXPIRED);
                            return;
                        }
                    }
                } else if (exception != null && this.$authType == LPAuthenticationType.AUTH && AuthRequest.access$getPerformSteUp$p(this.this$0)) {
                    if (AuthRequest.access$getRefreshUnAuthTokenForStepUp$p(this.this$0)) {
                        LPLog.INSTANCE.w("AuthRequest", "Failed to refresh UnAuth token. Abort step up. " + exception);
                        AuthRequest.access$setRefreshUnAuthTokenForStepUp$p(this.this$0, false);
                    } else {
                        Exception exception2 = exception;
                        if (!(exception2 instanceof HttpException)) {
                            exception2 = null;
                        }
                        HttpException httpException = (HttpException)exception2;
                        Integer statusCode = httpException != null ? Integer.valueOf(httpException.getCode()) : null;
                        Exception exception3 = exception;
                        if (!(exception3 instanceof HttpException)) {
                            exception3 = null;
                        }
                        HttpException httpException2 = (HttpException)exception3;
                        Integer internalCode = httpException2 != null ? AuthRequest.access$getInternalCode$p(this.this$0, httpException2) : null;
                        Integer n = statusCode;
                        int n2 = 401;
                        if (n != null && n == n2) {
                            Integer n3 = internalCode;
                            n2 = 1012;
                            if (n3 != null && n3 == n2) {
                                AuthRequest.access$refreshUnAuthTokenOnFailure(this.this$0, exception);
                                return;
                            }
                        }
                    }
                }
                AuthRequest.access$sendErrorCallback(this.this$0, exception, null);
            }
            {
                this.this$0 = $outer;
                this.$authType = $captured_local_variable$1;
                this.$httpPostRequest = $captured_local_variable$2;
            }
        });
        return httpPostRequest;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final JSONObject getRequestBody(LPAuthenticationType authType) {
        JSONObject jsonBody = new JSONObject();
        try {
            LPAuthenticationType lPAuthenticationType = authType;
            if (lPAuthenticationType == null) return null;
            switch (AuthRequest$WhenMappings.$EnumSwitchMapping$2[lPAuthenticationType.ordinal()]) {
                case 1: {
                    String authJwt;
                    LPAuthenticationParams lPAuthenticationParams = this.lpAuthenticationParams;
                    String authKey = lPAuthenticationParams != null ? lPAuthenticationParams.getAuthKey() : null;
                    LPAuthenticationParams lPAuthenticationParams2 = this.lpAuthenticationParams;
                    String string2 = authJwt = lPAuthenticationParams2 != null ? lPAuthenticationParams2.getHostAppJWT() : null;
                    if (!TextUtils.isEmpty((CharSequence)authKey)) {
                        jsonBody.put(KEY_CODE, (Object)authKey);
                        if (this.performSteUp) {
                            jsonBody.put(KEY_LP_JWT, (Object)this.getAuthToken());
                        }
                        LPAuthenticationParams lPAuthenticationParams3 = this.lpAuthenticationParams;
                        if (TextUtils.isEmpty((CharSequence)(lPAuthenticationParams3 != null ? lPAuthenticationParams3.getHostAppRedirectUri() : null))) {
                            jsonBody.put(KEY_REDIRECT_URI, (Object)DEFAULT_REDIRECT_URI);
                            return jsonBody;
                        } else {
                            LPAuthenticationParams lPAuthenticationParams4 = this.lpAuthenticationParams;
                            jsonBody.put(KEY_REDIRECT_URI, (Object)(lPAuthenticationParams4 != null ? lPAuthenticationParams4.getHostAppRedirectUri() : null));
                        }
                        return jsonBody;
                    }
                    if (!TextUtils.isEmpty((CharSequence)authJwt)) {
                        jsonBody.put(KEY_ID_TOKEN, (Object)authJwt);
                        if (!this.performSteUp) return jsonBody;
                        jsonBody.put(KEY_LP_JWT, (Object)this.getAuthToken());
                        return jsonBody;
                    }
                    this.sendErrorCallback(new Exception("getRequestBody: Failed to authenticate. No JWT nor authKey was provided"), AuthFailureReason.AUTH_INVALID);
                    return null;
                }
                case 2: {
                    String unAuthToken = this.getUnAuthToken();
                    if (TextUtils.isEmpty((CharSequence)unAuthToken)) return null;
                    jsonBody.put(KEY_ID_TOKEN, (Object)unAuthToken);
                    return jsonBody;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000013D, "getRequestBody: Failed to build request body for request of type: " + (Object)((Object)authType) + ". ", exception);
            this.sendErrorCallback(new Exception("getRequestBody: Failed to build request body for request of type: " + (Object)((Object)authType)), AuthFailureReason.CLIENT);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String generateIdpRequestUrl(LPAuthenticationType authType) {
        try {
            String string2;
            LPAuthenticationType lPAuthenticationType = authType;
            if (lPAuthenticationType != null) {
                switch (AuthRequest$WhenMappings.$EnumSwitchMapping$3[lPAuthenticationType.ordinal()]) {
                    case 1: {
                        if (this.performSteUp) {
                            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                            String string3 = IDP_UN_AUTH_URL;
                            Object[] objectArray = new Object[]{this.idpDomain, this.brandId, this.authConnectorId, AUTHENTICATE};
                            boolean bl = false;
                            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                            string2 = string4;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                            return string2;
                        }
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string5 = IDP_AUTH_URL;
                        Object[] objectArray = new Object[]{this.idpDomain, this.brandId, AUTHENTICATE};
                        boolean bl = false;
                        String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
                        string2 = string6;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
                        return string2;
                    }
                    case 2: {
                        if (this.isAnonymousRequest) {
                            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                            String string7 = IDP_ANONYMOUS_URL;
                            Object[] objectArray = new Object[]{this.idpDomain, this.brandId};
                            boolean bl = false;
                            String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
                            string2 = string8;
                            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"java.lang.String.format(format, *args)");
                            return string2;
                        }
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string9 = IDP_UN_AUTH_URL;
                        Object[] objectArray = new Object[]{this.idpDomain, this.brandId, this.unAuthConnectorId, AUTHENTICATE};
                        boolean bl = false;
                        String string10 = String.format(string9, Arrays.copyOf(objectArray, objectArray.length));
                        string2 = string10;
                        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"java.lang.String.format(format, *args)");
                        return string2;
                    }
                }
            }
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string11 = IDP_SIGNUP_URL;
            Object[] objectArray = new Object[]{this.idpDomain, this.brandId, SIGNUP};
            boolean bl = false;
            String string12 = String.format(string11, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string12;
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"java.lang.String.format(format, *args)");
            return string2;
        }
        catch (Exception error) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000013E, "generateIdpRequestUrl: Failed to generate IDP request URL. ", error);
            this.sendErrorCallback(new Exception("generateIdpRequestUrl: Failed to generate IDP request URL. " + error), AuthFailureReason.CLIENT);
            return null;
        }
    }

    private final void sendGeneralRequest(HttpPostRequest httpPostRequest) {
        if (httpPostRequest != null && !this.shouldCancelAuth) {
            httpPostRequest.setCertificatePinningKeys(this.certificates);
            LPLog.INSTANCE.d(TAG, "sendGeneralRequest: IDP request url : " + httpPostRequest.getUrl());
            httpPostRequest.setTimeout(30000);
            this.addHeaders(httpPostRequest);
            HttpHandler.execute(httpPostRequest);
        }
    }

    private final void addHeaders(HttpPostRequest httpPostRequest) {
        httpPostRequest.addHeader("sdkVersion", this.hostVersion);
        httpPostRequest.addHeader("platform", "Android");
        httpPostRequest.addHeader("platformVer", String.valueOf(Build.VERSION.SDK_INT));
        httpPostRequest.addHeader("device", Build.MODEL);
        httpPostRequest.addHeader("applicationId", StringsKt.replace$default((String)this.brandId, (String)"\n", (String)"", (boolean)false, (int)4, null));
    }

    public final void cancelAuth() {
        this.shouldCancelAuth = true;
    }

    private final void handleSuccess(String token) {
        block1: {
            if (this.shouldCancelAuth) break block1;
            String consumerId = TokenUtils.INSTANCE.getConsumerUserId(token);
            String originalConsumerId = TokenUtils.INSTANCE.getOriginalConsumerIdFromJWT(token);
            LPLog.INSTANCE.d(TAG, "handleSuccess: Extracted consumerId: " + LPLog.INSTANCE.mask(consumerId));
            AuthCallBack authCallBack = this.authCallBack;
            if (authCallBack != null) {
                authCallBack.onAuthSuccess(new Consumer(this.lpAuthenticationParams, this.brandId, consumerId, originalConsumerId, token));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void sendErrorCallback(Exception exception, AuthFailureReason authFailureReason) {
        block9: {
            LPLog.INSTANCE.e("AuthRequest", ErrorCode.ERR_0000013F, "sendErrorCallback: Sending error callback. (AuthFailureReason: " + authFailureReason + ')', exception);
            try {
                block10: {
                    block12: {
                        block11: {
                            failureReason = authFailureReason;
                            statusCode = null;
                            internalCode = null;
                            if (exception != null) {
                                v0 = exception;
                                if (!(v0 instanceof HttpException)) {
                                    v0 = null;
                                }
                                v1 = (HttpException)v0;
                                statusCode = v1 != null ? Integer.valueOf(v1.getCode()) : null;
                                v2 = exception;
                                if (!(v2 instanceof HttpException)) {
                                    v2 = null;
                                }
                                v3 = (HttpException)v2;
                                v4 = internalCode = v3 != null ? this.getInternalCode(v3) : null;
                            }
                            if (authFailureReason != null) break block10;
                            if (!(exception instanceof SSLPeerUnverifiedException)) break block11;
                            failureReason = AuthFailureReason.INVALID_CERTIFICATE;
                            break block10;
                        }
                        if (!(exception instanceof UnknownHostException)) break block12;
                        failureReason = AuthFailureReason.CLIENT;
                        break block10;
                    }
                    v5 = statusCode;
                    var6_7 = 598;
                    if (v5 != null && v5 == var6_7) ** GOTO lbl-1000
                    v6 = statusCode;
                    var6_7 = 599;
                    if (v6 != null && v6 == var6_7) lbl-1000:
                    // 2 sources

                    {
                        failureReason = AuthFailureReason.NETWORK;
                    } else if (statusCode != null && 500 <= (var6_7 = statusCode.intValue()) && 596 >= var6_7) {
                        failureReason = AuthFailureReason.IDP_FAILURE;
                    } else {
                        v7 = internalCode;
                        var6_7 = 1012;
                        failureReason = v7 != null && v7 == var6_7 ? AuthFailureReason.TOKEN_EXPIRED : AuthFailureReason.UNKNOWN;
                    }
                }
                v8 = this.authCallBack;
                if (v8 == null) break block9;
                v8.onAuthFailed(new AuthError(failureReason, exception, statusCode));
            }
            catch (Exception error) {
                LPLog.INSTANCE.e("AuthRequest", ErrorCode.ERR_00000140, "sendErrorCallback: Failed to send error callback: ", error);
                v9 = this.authCallBack;
                if (v9 == null) break block9;
                v9.onAuthFailed(new AuthError(AuthFailureReason.UNKNOWN, error, null));
            }
        }
    }

    private final Integer getInternalCode(@NotNull HttpException $this$internalCode) {
        Object object;
        HttpException httpException = $this$internalCode;
        boolean bl = false;
        try {
            object = Result.Companion;
            HttpException $this$runCatching = httpException;
            boolean bl2 = false;
            String string2 = $this$runCatching.getBody();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = new JSONObject(string2).optString("internalErrorCode");
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"JSONObject(body!!).optString(\"internalErrorCode\")");
            String string4 = string3;
            boolean bl3 = false;
            Integer n = Integer.parseInt(string4);
            boolean bl4 = false;
            object = Result.constructor-impl((Object)n);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl5 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        httpException = object;
        bl = false;
        return (Integer)((Object)(Result.isFailure-impl((Object)httpException) ? null : httpException));
    }

    private final void refreshUnAuthTokenOnFailure(Exception exception) {
        LPLog.INSTANCE.w(TAG, "Refresh Un Auth token because: " + exception);
        CharSequence charSequence = this.unAuthConnectorId;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            LPLog.INSTANCE.w(TAG, "Missing UnAuth connectorId. Abort Step-up");
            this.sendErrorCallback(exception, AuthFailureReason.STEP_UP_FAILURE);
            return;
        }
        this.refreshUnAuthTokenForStepUp = true;
        this.isAnonymousRequest = true;
        this.sendGeneralRequest(this.getHttpPostRequest(LPAuthenticationType.UN_AUTH));
    }

    private final void setUnAuthToken(String token) {
        if (token != null) {
            AuthPreferences.Companion.getInstance(this.applicationContext).setUnAuthToken(this.brandId, token);
        }
    }

    private final String getUnAuthToken() {
        return AuthPreferences.Companion.getInstance(this.applicationContext).getUnAuthToken(this.brandId, null);
    }

    private final void setAuthToken(String token) {
        if (token != null) {
            AuthPreferences.Companion.getInstance(this.applicationContext).setAuthToken(this.brandId, token);
        }
    }

    private final String getAuthToken() {
        return AuthPreferences.Companion.getInstance(this.applicationContext).getAuthToken(this.brandId, "");
    }

    public AuthRequest(@NotNull Context applicationContext, @NotNull String brandId, @Nullable String idpDomain, @Nullable LPAuthenticationParams lpAuthenticationParams, @Nullable String hostVersion, @Nullable List<String> certificates, @Nullable String unAuthConnectorId, @Nullable String authConnectorId, boolean performSteUp, @Nullable AuthCallBack authCallBack) {
        Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        this.applicationContext = applicationContext;
        this.brandId = brandId;
        this.idpDomain = idpDomain;
        this.lpAuthenticationParams = lpAuthenticationParams;
        this.hostVersion = hostVersion;
        this.certificates = certificates;
        this.unAuthConnectorId = unAuthConnectorId;
        this.authConnectorId = authConnectorId;
        this.performSteUp = performSteUp;
        this.authCallBack = authCallBack;
    }

    public static final /* synthetic */ boolean access$isAnonymousRequest$p(AuthRequest $this) {
        return $this.isAnonymousRequest;
    }

    public static final /* synthetic */ void access$setAnonymousRequest$p(AuthRequest $this, boolean bl) {
        $this.isAnonymousRequest = bl;
    }

    public static final /* synthetic */ void access$setUnAuthToken(AuthRequest $this, String token) {
        $this.setUnAuthToken(token);
    }

    public static final /* synthetic */ void access$sendGeneralRequest(AuthRequest $this, HttpPostRequest httpPostRequest) {
        $this.sendGeneralRequest(httpPostRequest);
    }

    public static final /* synthetic */ HttpPostRequest access$getHttpPostRequest(AuthRequest $this, LPAuthenticationType authType) {
        return $this.getHttpPostRequest(authType);
    }

    public static final /* synthetic */ boolean access$getRefreshUnAuthTokenForStepUp$p(AuthRequest $this) {
        return $this.refreshUnAuthTokenForStepUp;
    }

    public static final /* synthetic */ void access$setRefreshUnAuthTokenForStepUp$p(AuthRequest $this, boolean bl) {
        $this.refreshUnAuthTokenForStepUp = bl;
    }

    public static final /* synthetic */ void access$setAuthToken(AuthRequest $this, String token) {
        $this.setAuthToken(token);
    }

    public static final /* synthetic */ void access$handleSuccess(AuthRequest $this, String token) {
        $this.handleSuccess(token);
    }

    public static final /* synthetic */ void access$sendErrorCallback(AuthRequest $this, Exception exception, AuthFailureReason authFailureReason) {
        $this.sendErrorCallback(exception, authFailureReason);
    }

    public static final /* synthetic */ String access$getUnAuthToken(AuthRequest $this) {
        return $this.getUnAuthToken();
    }

    public static final /* synthetic */ boolean access$getPerformSteUp$p(AuthRequest $this) {
        return $this.performSteUp;
    }

    public static final /* synthetic */ Integer access$getInternalCode$p(AuthRequest $this, HttpException $this$access_u24internalCode_u24p) {
        return $this.getInternalCode($this$access_u24internalCode_u24p);
    }

    public static final /* synthetic */ void access$refreshUnAuthTokenOnFailure(AuthRequest $this, Exception exception) {
        $this.refreshUnAuthTokenOnFailure(exception);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000e\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/liveperson/infra/network/http/requests/AuthRequest$Companion;", "", "()V", "AUTHENTICATE", "", "DEFAULT_REDIRECT_URI", "IDP_ANONYMOUS_URL", "IDP_AUTH_URL", "IDP_REQUEST_TIMEOUT", "", "IDP_SIGNUP_URL", "IDP_TOKEN_EXPIRED", "IDP_UN_AUTH_URL", "KEY_CODE", "KEY_ID_TOKEN", "KEY_LP_JWT", "KEY_REDIRECT_URI", "NETWORK_CONNECT_TIMEOUT_ERROR_CODE", "NETWORK_READ_TIMEOUT_ERROR_CODE", "SIGNUP", "TAG", "UN_AUTHORIZED_ERROR_CODE", "USER_EXPIRED_ERROR", "infra_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

