/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.statemachine;

import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.statemachine.interfaces.IEvent;
import com.liveperson.infra.statemachine.interfaces.IState;
import com.liveperson.infra.statemachine.interfaces.IStateMachine;
import com.liveperson.infra.statemachine.interfaces.IStateMachineExecutor;
import com.liveperson.infra.utils.DispatchQueue;

public class StateMachineExecutor
implements IStateMachineExecutor {
    private final String logTag;
    private final IStateMachine<IState> stateMachine;
    private DispatchQueue mDispatchQueue;

    public StateMachineExecutor(String logTag, IStateMachine<IState> stateMachine) {
        this.logTag = logTag;
        this.stateMachine = stateMachine;
        this.mDispatchQueue = new DispatchQueue(logTag);
    }

    @Override
    public void shutdown() {
        this.mDispatchQueue.dispose();
    }

    @Override
    public boolean isInitialized() {
        return !this.isThreadDead();
    }

    @Override
    public void post(IEvent event) {
        if (this.isThreadDead()) {
            return;
        }
        this.mDispatchQueue.postRunnable(new RunnableWrapper(event));
    }

    @Override
    public Runnable schedule(IEvent event, long delay) {
        if (this.isThreadDead()) {
            return null;
        }
        RunnableWrapper runnable = new RunnableWrapper(event);
        this.mDispatchQueue.postRunnable(runnable, delay);
        return runnable;
    }

    @Override
    public void cancel(Runnable delayedEvent) {
        if (this.isThreadDead()) {
            return;
        }
        this.mDispatchQueue.removeRunnable(delayedEvent);
    }

    private boolean isThreadDead() {
        if (!this.mDispatchQueue.isAlive()) {
            LPLog.INSTANCE.w(this.logTag, "State Machine DispatchQueue is dead.");
            return true;
        }
        return false;
    }

    class RunnableWrapper
    implements Runnable {
        final IEvent event;

        RunnableWrapper(IEvent iEvent) {
            this.event = iEvent;
        }

        @Override
        public void run() {
            LPLog.INSTANCE.d(StateMachineExecutor.this.logTag, StateMachineExecutor.this.stateMachine.activeState().toString() + " <-<- " + this.event.toString());
            this.event.accept((IState)StateMachineExecutor.this.stateMachine.activeState());
        }
    }
}

