/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.AndroidFrameworkUtils;

public class VersionUtils {
    private static final String TAG = "VersionUtils";

    public static boolean isValidSdkVersion(String minSdkVersion) {
        String hostVersion = Infra.instance.getHostVersion();
        if (VersionUtils.versionCompare(hostVersion, minSdkVersion) < 0) {
            LPLog.INSTANCE.w(TAG, "isValidSdkVersion: Current SDK version (" + hostVersion + ") is smaller than the one from the server (" + minSdkVersion + "). ");
            return false;
        }
        LPLog.INSTANCE.d(TAG, "isValidSdkVersion: Version check is OK");
        return true;
    }

    private static Integer versionCompare(String str1, String str2) throws NullPointerException {
        int i;
        LPLog.INSTANCE.d(TAG, "versionCompare str1 " + str1);
        LPLog.INSTANCE.d(TAG, "versionCompare str2 " + str2);
        if (TextUtils.isEmpty((CharSequence)str1) || TextUtils.isEmpty((CharSequence)str2)) {
            LPLog.INSTANCE.w(TAG, "versionCompare: one of the compared version is null or empty");
            return 0;
        }
        String[] values1 = str1.split("\\.");
        String[] values2 = str2.split("\\.");
        for (i = 0; i < values1.length && i < values2.length && values1[i].equals(values2[i]); ++i) {
        }
        if (i < values1.length && i < values2.length) {
            int diff = Integer.valueOf(values1[i]).compareTo(Integer.valueOf(values2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(values1.length - values2.length);
    }

    @NonNull
    public static String getAppVersion(@NonNull Context appContext) {
        try {
            return AndroidFrameworkUtils.getAppVersion(appContext);
        }
        catch (NullPointerException npe) {
            LPLog.INSTANCE.w(TAG, "NPE while trying to fetch our app's version number!", npe);
            return "";
        }
    }
}

