package com.liveperson.infra.model;


import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.utils.EncryptionVersion;

/**
 * Created by ofira on 09/07/2015.
 */
public class Message {

    public static final String EXTRA_MESSAGE_TEXT = "EXTRA_MESSAGE_TEXT";

    private int mServerSequence = -1;
    private String mMessage;
    private String metadata;
    private String mContentType = "text/plain";
    protected long mId;
    private String mDialogId;

    private long mTimeStamp;
    private String mOriginatorId;
    private String mEventId;//Unique id sent to server with this message. we keep it in order to update the server sequence ID

    public Message(String originatorId, String message, long timeStamp, String dialogId, String eventId, EncryptionVersion encryptionVersion) {
        mOriginatorId = originatorId;
        mMessage = DBEncryptionHelper.decrypt(encryptionVersion, message);
        mTimeStamp = timeStamp;
        mDialogId = dialogId;
        mEventId = eventId;
    }

    @Override
    public String toString() {
        return String.format("Message %s\nDialog id %s\nTimeStamp %s\nEventId %s\nServerSequence %s\nOriginatorId %s", mMessage, mDialogId, mTimeStamp, mEventId, mServerSequence, mOriginatorId);
    }

    public long getLocalId() {
        return mId;
    }


    public void setMessageId(long messageId) {
        mId = messageId;
    }


    public String getMessage() {
        return mMessage;
    }

    public void setMessage(String message) {
        this.mMessage = message;
    }

    public long getTimeStamp() {
        return mTimeStamp;
    }

    public String getDialogId() {
        return mDialogId;
    }

    public String getContentType() {
        return mContentType;
    }

    public int getServerSequence() {
        return mServerSequence;
    }

    public String getOriginatorId() {
        return mOriginatorId;
    }

    public void setDialogId(String dialogId) {
        this.mDialogId = dialogId;
    }

    public void setContentType(String contentType) {
        mContentType = contentType;
    }

    public void setEventId(String eventId) {
        mEventId = eventId;
    }

    public String getEventId() {
        return mEventId;
    }

    public void setServerSequence(int serverSequence) {
        mServerSequence = serverSequence;
    }

    public String getMetadata() {
        return metadata;
    }

    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }
}
