package com.liveperson.infra.utils;

import com.liveperson.infra.Infra;

import java.util.ArrayList;

/**
 * Created by Perry on 30/07/2017 and supervised by Perry.
 *
 * From:
 * https://github.com/PerrchicK/android-app/blob/59804a874f8f845c6ad8d7cf13d5acba35ee7a37/app/src/main/java/com/perrchick/someapplication/utilities/Synchronizer.java
 */
public class Synchronizer<T> {
    private boolean hasBeenCanceled;
    private int holdersCount = 0;
    private final SynchronizerCallback<T> futureTask;
    private ArrayList<T> allHoldersResults;

    public Synchronizer(SynchronizerCallback<T> lastAction) {
        futureTask = lastAction;
        allHoldersResults = new ArrayList<>();
        hasBeenCanceled = false;
    }

    public Holder createHolder() {
        holdersCount++;

        return new Holder();
    }

    public class Holder {
        private boolean isReleased;


        private Holder() {
            isReleased = false;
        }

        public void release() {
            release(null);
        }

        public void release(T extra) {
            release(extra, false);
        }

        private void release(final T extra, boolean afterDelay) {
            if (hasBeenCanceled) return;

            if (isReleased) return;

            if (holdersCount == 1 && !afterDelay) {
                Infra.instance.getApplicationHandler().postDelayed(() -> release(extra, true), 100);
                return;
            }

            isReleased = true;

            allHoldersResults.add(extra);
            holdersCount--;

            if (holdersCount == 0) {
                futureTask.done(allHoldersResults);
            }
        }
    }

    public interface SynchronizerCallback<T> {
        void done(ArrayList<T> extra);
    }
}