/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.managers;

import android.content.Context;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.callbacks.AuthCallBack;
import com.liveperson.infra.callbacks.AuthStateSubscription;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.Consumer;
import com.liveperson.infra.model.errors.AuthError;
import com.liveperson.infra.model.types.AuthFailureReason;
import com.liveperson.infra.network.http.requests.AuthRequest;
import com.liveperson.infra.preferences.AuthPreferences;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\r\b\u0016\u0018\u0000 =2\u00020\u0001:\u0002<=B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0004\u001a\u00020\u0005J\u001a\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\bH\u0002J\u0010\u0010#\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\bH\u0002J\u001c\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190(J\b\u0010)\u001a\u00020*H\u0016J\u0006\u0010+\u001a\u00020*J\\\u0010,\u001a\u00020\u00192\b\u0010-\u001a\u0004\u0018\u00010 2\b\u0010.\u001a\u0004\u0018\u00010\u00052\b\u0010/\u001a\u0004\u0018\u00010\u00052\u0010\u00100\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u0001012\b\u00102\u001a\u0004\u0018\u00010\u00052\b\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020*2\b\u00105\u001a\u0004\u0018\u00010\u0011J\u0006\u00106\u001a\u00020\u0019J\u0006\u00107\u001a\u00020\u0019J\u0006\u00108\u001a\u00020\u0019J\u0010\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\u0017H\u0016J\u000e\u0010;\u001a\u00020*2\u0006\u0010:\u001a\u00020\u0017R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/liveperson/infra/managers/ConsumerManager;", "", "appContext", "Landroid/content/Context;", "brandId", "", "(Landroid/content/Context;Ljava/lang/String;)V", "activeConsumer", "Lcom/liveperson/infra/model/Consumer;", "activeRequest", "Lcom/liveperson/infra/network/http/requests/AuthRequest;", "authPrefs", "Lcom/liveperson/infra/preferences/AuthPreferences;", "authState", "Lcom/liveperson/infra/managers/ConsumerManager$AuthState;", "callbacks", "", "Lcom/liveperson/infra/callbacks/AuthCallBack;", "isTokenExpirationHandled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "mostRecentError", "Lcom/liveperson/infra/model/errors/AuthError;", "subscriptions", "Lcom/liveperson/infra/callbacks/AuthStateSubscription;", "clearDataAndShutdown", "", "getActiveConsumer", "getCurrentConsumerAuthType", "Lcom/liveperson/infra/auth/LPAuthenticationType;", "handleAuthFailure", "authError", "initialAuthParams", "Lcom/liveperson/infra/auth/LPAuthenticationParams;", "handleAuthSuccessful", "newConsumer", "handleConsumerChange", "handleTokenExpiration", "exception", "Ljava/lang/Exception;", "block", "Lkotlin/Function0;", "hasActiveConsumer", "", "isAuthenticated", "login", "authParams", "idpDomain", "hostVersion", "certs", "", "unAuthConnectorId", "authConnectorId", "performSteUp", "callback", "resetAuthState", "setIsAuthenticated", "shutdown", "subscribeToAuthStateChanges", "subscription", "unsubscribeFromAuthStateChanges", "AuthState", "Companion", "infra_release"})
public class ConsumerManager {
    private AuthState authState;
    private final AuthPreferences authPrefs;
    private Consumer activeConsumer;
    private AuthError mostRecentError;
    private AuthRequest activeRequest;
    private final Set<AuthCallBack> callbacks;
    private final Set<AuthStateSubscription> subscriptions;
    private final AtomicBoolean isTokenExpirationHandled;
    private final Context appContext;
    private final String brandId;
    private static final String TAG = "ConsumerManager";
    public static final Companion Companion = new Companion(null);

    public synchronized boolean hasActiveConsumer() {
        return this.activeConsumer != null;
    }

    @Nullable
    public synchronized Consumer getActiveConsumer() {
        return this.activeConsumer;
    }

    public final synchronized boolean isAuthenticated() {
        return this.authState == AuthState.AUTHENTICATED && this.activeConsumer != null;
    }

    public final synchronized void resetAuthState() {
        this.authState = AuthState.NOT_AUTHENTICATED;
    }

    public final synchronized void setIsAuthenticated() {
        this.authState = AuthState.AUTHENTICATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleAuthSuccessful(Consumer newConsumer) {
        LPLog.INSTANCE.i(TAG, "Successfully logged in " + LPLog.INSTANCE.mask(newConsumer));
        this.isTokenExpirationHandled.set(false);
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            AuthState oldState = this.authState;
            Consumer oldConsumer = this.activeConsumer;
            this.authState = AuthState.AUTHENTICATED;
            this.activeConsumer = newConsumer;
            this.mostRecentError = null;
            if (ForegroundService.getInstance().isBrandForeground(this.brandId)) {
                this.authPrefs.setCachedConsumer(this.brandId, newConsumer);
            }
            for (AuthStateSubscription subscription : this.subscriptions) {
                subscription.onAuthStateChanged(oldState, this.authState, oldConsumer, newConsumer);
            }
            for (AuthCallBack callback2 : this.callbacks) {
                callback2.onAuthSuccess(newConsumer);
            }
            this.callbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleConsumerChange(Consumer newConsumer) {
        LPLog.INSTANCE.i(TAG, "Encountered unexpected consumerId; performing consumer swap from " + LPLog.INSTANCE.mask(this.activeConsumer) + " to " + LPLog.INSTANCE.mask(newConsumer) + '.');
        this.isTokenExpirationHandled.set(false);
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            Consumer oldConsumer = this.activeConsumer;
            this.authState = AuthState.AUTHENTICATED;
            this.activeConsumer = newConsumer;
            this.mostRecentError = null;
            if (ForegroundService.getInstance().isBrandForeground(this.brandId)) {
                this.authPrefs.setCachedConsumer(this.brandId, newConsumer);
            }
            for (AuthStateSubscription subscription : this.subscriptions) {
                subscription.onAuthStateChanged(AuthState.AUTHENTICATED, AuthState.AUTHENTICATED, oldConsumer, newConsumer);
            }
            for (AuthCallBack callback2 : this.callbacks) {
                Consumer consumer = oldConsumer;
                if (consumer == null) {
                    Intrinsics.throwNpe();
                }
                callback2.onConsumerSwitch(consumer, newConsumer);
            }
            this.callbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void handleAuthFailure(AuthError authError, LPAuthenticationParams initialAuthParams) {
        LPLog.INSTANCE.w("ConsumerManager", "Auth failed. Reason: " + authError);
        this.isTokenExpirationHandled.set(false);
        var3_3 = this;
        var4_4 = false;
        var5_5 = false;
        synchronized (var3_3) {
            $i$a$-synchronized-ConsumerManager$handleAuthFailure$1 = false;
            oldState = this.authState;
            oldConsumer = this.activeConsumer;
            v0 = initialAuthParams;
            if (v0 == null) ** GOTO lbl-1000
            var9_11 = v0;
            var10_12 = false;
            var11_14 = false;
            it = var9_11;
            $i$a$-let-ConsumerManager$handleAuthFailure$1$shouldSave$1 = false;
            if (it.getAuthType() != LPAuthenticationType.AUTH) ** GOTO lbl-1000
            var14_19 = it.getAuthKey();
            var15_20 = false;
            var16_21 = false;
            if (!(var14_19 == null || StringsKt.isBlank((CharSequence)var14_19) != false)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = false;
            }
            var9_11 = v1;
            var10_12 = false;
            var11_14 = false;
            it = var9_11.booleanValue();
            $i$a$-takeIf-ConsumerManager$handleAuthFailure$1$shouldSave$2 = false;
            v2 = authError.getStatusCode();
            v0 = (v2 != null && v2 == 401) != false ? var9_11 : null;
            if (v0 != null) {
                v3 = v0.booleanValue();
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            shouldSave = v3;
            this.authState = AuthState.AUTH_FAILED;
            v4 = this;
            v5 = oldConsumer;
            if (v5 != null) {
                var9_11 = v5;
                var18_23 = v4;
                var10_12 = false;
                var11_14 = false;
                it = var9_11;
                $i$a$-takeIf-ConsumerManager$handleAuthFailure$1$1 = false;
                var19_24 = shouldSave != false ? var9_11 : null;
                v4 = var18_23;
                v6 = var19_24;
            } else {
                v6 = null;
            }
            v4.activeConsumer = v6;
            this.mostRecentError = authError;
            this.authPrefs.setCachedConsumer(this.brandId, null);
            for (AuthStateSubscription subscription : this.subscriptions) {
                subscription.onAuthStateChanged(oldState, this.authState, oldConsumer, null);
            }
            for (AuthCallBack callback : this.callbacks) {
                callback.onAuthFailed(authError);
            }
            this.callbacks.clear();
            var5_6 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleTokenExpiration(@NotNull Exception exception, @NotNull Function0<Unit> block) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        if (this.isTokenExpirationHandled.compareAndSet(false, true)) {
            block.invoke();
        }
        ConsumerManager consumerManager = this;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (consumerManager) {
            boolean bl3 = false;
            AuthState oldState = this.authState;
            Consumer oldConsumer = this.activeConsumer;
            for (AuthStateSubscription subscription : this.subscriptions) {
                subscription.onAuthStateChanged(oldState, AuthState.EXPIRED, oldConsumer, null);
            }
            for (AuthCallBack callback2 : this.callbacks) {
                callback2.onAuthFailed(new AuthError(AuthFailureReason.TOKEN_EXPIRED, exception, 401));
            }
            this.callbacks.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    public final synchronized void login(@Nullable LPAuthenticationParams authParams, @Nullable String idpDomain, @Nullable String hostVersion, @Nullable List<String> certs, @Nullable String unAuthConnectorId, @Nullable String authConnectorId, boolean performSteUp, @Nullable AuthCallBack callback2) {
        AuthRequest authRequest;
        boolean bl;
        AuthRequest authRequest2 = this.activeRequest;
        if (authRequest2 != null) {
            AuthRequest authRequest3 = authRequest2;
            boolean bl2 = false;
            bl = false;
            AuthRequest it = authRequest3;
            boolean bl3 = false;
            it.cancelAuth();
            this.activeRequest = null;
        }
        AuthState oldState = this.authState;
        this.authState = AuthState.AUTH_IN_PROGRESS;
        AuthCallBack authCallBack = callback2;
        if (authCallBack != null) {
            AuthCallBack authCallBack2 = authCallBack;
            bl = false;
            boolean bl4 = false;
            AuthCallBack it = authCallBack2;
            boolean bl5 = false;
            this.callbacks.add(it);
        }
        AuthCallBack callback3 = new AuthCallBack(this, authParams){
            final /* synthetic */ ConsumerManager this$0;
            final /* synthetic */ LPAuthenticationParams $authParams;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void onAuthSuccess(@NotNull Consumer consumer) {
                Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
                var2_2 = this.this$0;
                var3_3 = false;
                var4_4 = false;
                synchronized (var2_2) {
                    $i$a$-synchronized-ConsumerManager$login$callback$1$onAuthSuccess$1 = false;
                    if (ConsumerManager.access$getActiveConsumer$p(this.this$0) == null) ** GOTO lbl-1000
                    v0 = ConsumerManager.access$getActiveConsumer$p(this.this$0);
                    if (v0 == null) {
                        Intrinsics.throwNpe();
                    }
                    var6_8 = v0.getConsumerId();
                    var7_9 = false;
                    var8_10 = false;
                    if (!(var6_8 == null || var6_8.length() == 0) && Intrinsics.areEqual((Object)ConsumerManager.access$getActiveConsumer$p(this.this$0), (Object)consumer) ^ true) {
                        ConsumerManager.access$handleConsumerChange(this.this$0, consumer);
                    } else lbl-1000:
                    // 2 sources

                    {
                        ConsumerManager.access$handleAuthSuccessful(this.this$0, consumer);
                    }
                    var4_5 = Unit.INSTANCE;
                }
            }

            public void onConsumerSwitch(@NotNull Consumer oldConsumer, @NotNull Consumer newConsumer) {
                Intrinsics.checkParameterIsNotNull((Object)oldConsumer, (String)"oldConsumer");
                Intrinsics.checkParameterIsNotNull((Object)newConsumer, (String)"newConsumer");
            }

            public void onAuthFailed(@NotNull AuthError error) {
                Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
                ConsumerManager.access$handleAuthFailure(this.this$0, error, this.$authParams);
            }
            {
                this.this$0 = $outer;
                this.$authParams = $captured_local_variable$1;
            }
        };
        AuthRequest authRequest4 = new AuthRequest(this.appContext, this.brandId, idpDomain, authParams, hostVersion, certs, unAuthConnectorId, authConnectorId, performSteUp, callback3);
        ConsumerManager consumerManager = this;
        boolean bl6 = false;
        boolean bl7 = false;
        AuthRequest it = authRequest4;
        boolean bl8 = false;
        it.authenticate();
        consumerManager.activeRequest = authRequest = authRequest4;
        for (AuthStateSubscription subscription : this.subscriptions) {
            subscription.onAuthStateChanged(oldState, this.authState, this.activeConsumer, this.activeConsumer);
        }
    }

    public synchronized void subscribeToAuthStateChanges(@NotNull AuthStateSubscription subscription) {
        Intrinsics.checkParameterIsNotNull((Object)subscription, (String)"subscription");
        this.subscriptions.add(subscription);
    }

    public final synchronized boolean unsubscribeFromAuthStateChanges(@NotNull AuthStateSubscription subscription) {
        Intrinsics.checkParameterIsNotNull((Object)subscription, (String)"subscription");
        return this.subscriptions.remove(subscription);
    }

    public final void shutdown() {
        AuthRequest authRequest = this.activeRequest;
        if (authRequest != null) {
            AuthRequest authRequest2 = authRequest;
            boolean bl = false;
            boolean bl2 = false;
            AuthRequest it = authRequest2;
            boolean bl3 = false;
            it.cancelAuth();
            this.activeRequest = null;
        }
        AuthState oldState = this.authState;
        Consumer oldConsumer = this.activeConsumer;
        this.authState = AuthState.NOT_AUTHENTICATED;
        this.activeConsumer = null;
        for (AuthStateSubscription subscription : this.subscriptions) {
            subscription.onAuthStateChanged(oldState, this.authState, oldConsumer, null);
        }
        this.callbacks.clear();
        this.subscriptions.clear();
    }

    @Nullable
    public final LPAuthenticationType getCurrentConsumerAuthType(@NotNull String brandId) {
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        return this.authPrefs.getCurrentAuthType(brandId);
    }

    public synchronized void clearDataAndShutdown() {
        this.authPrefs.clearAll();
        this.shutdown();
    }

    public ConsumerManager(@NotNull Context appContext, @NotNull String brandId) {
        Intrinsics.checkParameterIsNotNull((Object)appContext, (String)"appContext");
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        this.appContext = appContext;
        this.brandId = brandId;
        this.authState = AuthState.NOT_AUTHENTICATED;
        this.authPrefs = AuthPreferences.Companion.getInstance(this.appContext);
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"Collections.newSetFromMap(ConcurrentHashMap())");
        this.callbacks = set;
        Set set2 = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"Collections.newSetFromMap(ConcurrentHashMap())");
        this.subscriptions = set2;
        this.isTokenExpirationHandled = new AtomicBoolean(false);
        CharSequence charSequence = this.brandId;
        boolean bl = false;
        if (charSequence.length() > 0) {
            this.activeConsumer = this.authPrefs.getCachedConsumer(this.brandId);
        }
    }

    public static final /* synthetic */ Consumer access$getActiveConsumer$p(ConsumerManager $this) {
        return $this.activeConsumer;
    }

    public static final /* synthetic */ void access$setActiveConsumer$p(ConsumerManager $this, Consumer consumer) {
        $this.activeConsumer = consumer;
    }

    public static final /* synthetic */ void access$handleConsumerChange(ConsumerManager $this, Consumer newConsumer) {
        $this.handleConsumerChange(newConsumer);
    }

    public static final /* synthetic */ void access$handleAuthSuccessful(ConsumerManager $this, Consumer newConsumer) {
        $this.handleAuthSuccessful(newConsumer);
    }

    public static final /* synthetic */ void access$handleAuthFailure(ConsumerManager $this, AuthError authError, LPAuthenticationParams initialAuthParams) {
        $this.handleAuthFailure(authError, initialAuthParams);
    }

    @JvmStatic
    @Nullable
    public static final String getConsumerJWT(@Nullable Consumer $this$getConsumerJWT) {
        return Companion.getConsumerJWT($this$getConsumerJWT);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/liveperson/infra/managers/ConsumerManager$AuthState;", "", "(Ljava/lang/String;I)V", "NOT_AUTHENTICATED", "AUTH_IN_PROGRESS", "AUTHENTICATED", "AUTH_FAILED", "EXPIRED", "infra_release"})
    public static final class AuthState
    extends Enum<AuthState> {
        public static final /* enum */ AuthState NOT_AUTHENTICATED;
        public static final /* enum */ AuthState AUTH_IN_PROGRESS;
        public static final /* enum */ AuthState AUTHENTICATED;
        public static final /* enum */ AuthState AUTH_FAILED;
        public static final /* enum */ AuthState EXPIRED;
        private static final /* synthetic */ AuthState[] $VALUES;

        static {
            AuthState[] authStateArray = new AuthState[5];
            AuthState[] authStateArray2 = authStateArray;
            authStateArray[0] = NOT_AUTHENTICATED = new AuthState();
            authStateArray[1] = AUTH_IN_PROGRESS = new AuthState();
            authStateArray[2] = AUTHENTICATED = new AuthState();
            authStateArray[3] = AUTH_FAILED = new AuthState();
            authStateArray[4] = EXPIRED = new AuthState();
            $VALUES = authStateArray;
        }

        public static AuthState[] values() {
            return (AuthState[])$VALUES.clone();
        }

        public static AuthState valueOf(String string2) {
            return Enum.valueOf(AuthState.class, string2);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/liveperson/infra/managers/ConsumerManager$Companion;", "", "()V", "TAG", "", "getConsumerJWT", "Lcom/liveperson/infra/model/Consumer;", "infra_release"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @Nullable
        public final String getConsumerJWT(@Nullable Consumer $this$getConsumerJWT) {
            Consumer consumer = $this$getConsumerJWT;
            Object object = consumer;
            if (consumer == null) return null;
            LPAuthenticationParams lPAuthenticationParams = ((Consumer)object).getLpAuthenticationParams();
            object = lPAuthenticationParams;
            if (lPAuthenticationParams == null) return null;
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            if (((LPAuthenticationParams)it).getAuthType() != LPAuthenticationType.AUTH) return null;
            boolean bl4 = true;
            if (!bl4) return null;
            Object object3 = object2;
            object = object3;
            if (object3 == null) return null;
            String string2 = ((LPAuthenticationParams)object).getHostAppJWT();
            return string2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

