/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.managers;

import android.content.Context;
import android.content.SharedPreferences;
import com.liveperson.infra.Infra;
import com.liveperson.infra.log.LPLog;
import java.util.Set;

public class PreferenceManager {
    private static final String TAG = "PreferenceManager";
    private static final String LP_SHARED_FILENAME = "lp_shared";
    public static final String APP_LEVEL_PREFERENCES = "appLevelPreferences";
    public static final String SDK_VERSION_CHANGED_CLEAR_DATABASE_KEY = "SDK_VERSION_CHANGED_CLEAR_DATABASE_KEY";
    public static final String SDK_VERSION_PREFERENCE_KEY = "SDK_VERSION_PREFERENCE_KEY";
    public static final String RESET_DB_ENCRYPTION_SERVICE_KEY = "RESET_DB_ENCRYPTION_SERVICE_KEY";
    public static final String KILL_SWITCH_PHOTO_SHARING_ENABLED_PREFERENCE_KEY = "kill_switch_photo_sharing_enabled_preference_key";
    public static final String SITE_SETTINGS_PHOTO_SHARING_ENABLED_PREFERENCE_KEY = "site_settings_photo_sharing_enabled_preference_key";
    public static final String SITE_SETTINGS_VOICE_SHARING_ENABLED_PREFERENCE_KEY = "site_settings_voice_sharing_enabled_preference_key";
    public static final String SITE_SETTINGS_SDK_ANALYTICS_ENABLED_PREFERENCE_KEY = "site_settings_sdk_analytics_enabled_preference_key";
    public static final String SITE_SETTINGS_EVENT_MANAGER_DOMAIN_PREFERENCE_KEY = "site_settings_event_manager_domain_preference_key";
    public static final String SITE_SETTINGS_THUMBNAIL_BLUR_ENABLED_PREFERENCE_KEY = "site_settings_thumbnail_blur_enabled_preference_key";
    public static final String ENABLE_TRANSCENDENT_MESSAGES_PREFERENCE_KEY = "enable_transcendent_messages_preference_key";
    public static final String CONFIGURATION_DATA_PUBLISH_DATE_PREFERENCE_KEY = "configuration_data_publish_date_preference_key";
    public static final String IS_PUSHER_REGISTERED_PREFERENCE_KEY = "IS_PUSHER_REGISTERED_PREFERENCE_KEY";
    public static final String APP_ID_PREFERENCE_KEY = "APP_ID_PREFERENCE_KEY";
    public static final String PUSHER_DEVICE_TOKEN_PREFERENCE_KEY = "PUSHER_DEVICE_TOKEN_PREFERENCE_KEY";
    public static final String CONSUMER_UNREGISTER_PUSHER_PREFERENCE_KEY = "CONSUMER_UNREGISTER_PUSHER_PREFERENCE_KEY";
    public static final String KEY_TYPED_TEXT = "KEY_TYPED_TEXT";
    public static final String KEY_LATEST_OPEN_CONVERSATION_ID = "latest_open_conversation_id";
    public static final String KEY_AUTH_CONNECTOR_ID = "KEY_AUTH_CONNECTOR_ID";
    private static volatile SharedPreferences mPreferences;
    private static volatile PreferenceManager Instance;

    private PreferenceManager() {
        Context applicationContext = Infra.instance.getApplicationContext();
        mPreferences = applicationContext.getSharedPreferences(LP_SHARED_FILENAME, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PreferenceManager getInstance() {
        if (Instance != null) return Instance;
        Class<PreferenceManager> clazz = PreferenceManager.class;
        synchronized (PreferenceManager.class) {
            if (Instance != null) return Instance;
            Instance = new PreferenceManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return Instance;
        }
    }

    public void setLongValue(String key, String brandId, long value) {
        mPreferences.edit().putLong(this.buildKey(key, brandId), value).apply();
    }

    public long getLongValue(String key, String brandId, long defValue) {
        return mPreferences.getLong(this.buildKey(key, brandId), defValue);
    }

    public void setBooleanValue(String key, String brandId, boolean value) {
        mPreferences.edit().putBoolean(this.buildKey(key, brandId), value).apply();
    }

    public boolean getBooleanValue(String key, String brandId, boolean defValue) {
        return mPreferences.getBoolean(this.buildKey(key, brandId), defValue);
    }

    public Set<String> getStringSet(String key, String brandId, Set<String> defValues) {
        return mPreferences.getStringSet(this.buildKey(key, brandId), defValues);
    }

    public void setIntValue(String key, String brandId, int value) {
        mPreferences.edit().putInt(this.buildKey(key, brandId), value).apply();
    }

    public int getIntValue(String key, String brandId, int defValue) {
        return mPreferences.getInt(this.buildKey(key, brandId), defValue);
    }

    public String getStringValue(String key, String brandId, String defValue) {
        return mPreferences.getString(this.buildKey(key, brandId), defValue);
    }

    public void setStringValue(String key, String brandId, String value) {
        mPreferences.edit().putString(this.buildKey(key, brandId), value).apply();
    }

    public void setStringsSet(String key, String brandId, Set<String> value) {
        mPreferences.edit().putStringSet(this.buildKey(key, brandId), value).apply();
    }

    public void remove(String key, String brandId) {
        mPreferences.edit().remove(this.buildKey(key, brandId)).apply();
    }

    public boolean contains(String key, String brandId) {
        return mPreferences.contains(this.buildKey(key, brandId));
    }

    public void clearAll() {
        LPLog.INSTANCE.d(TAG, "Clearing all data");
        mPreferences.edit().clear().apply();
    }

    private String buildKey(String key, String brandId) {
        return key + "$$" + brandId;
    }

    static {
        Instance = null;
    }
}

