/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.network.http.request;

import android.util.Pair;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.http.HttpUtilsKt;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;

public abstract class HttpRequest {
    private static final String TAG = "HttpRequest";
    private static final int DEFAULT_TIMEOUT = 30000;
    private int mTimeout = 30000;
    private String mUrl;
    private HttpMethod mMethod;
    private List<Pair<String, String>> mHeaders;
    protected HttpRequestBody mRequestBody;
    protected ICallback mCallback;
    private List<String> mCertificatePinningKeys;
    private static final String USER_AGENT = "User-Agent";
    private static final String ANDROID = "ANDROID";

    public HttpRequest(String url, HttpMethod method) {
        this.mUrl = url;
        this.mMethod = method;
        this.mHeaders = new ArrayList<Pair<String, String>>();
        this.mHeaders.add((Pair<String, String>)Pair.create((Object)USER_AGENT, (Object)ANDROID));
    }

    public void processResponse(Response response) {
        try {
            if (this.isResponseSuccessful(response)) {
                LPLog.INSTANCE.i(TAG, "onSuccess! " + response.code());
                if (this.mCallback != null) {
                    this.reportSuccess(response);
                }
            } else {
                LPLog.INSTANCE.i(TAG, "onResponseFailure " + response);
                if (this.mCallback != null) {
                    Exception exception = HttpUtilsKt.asException(response);
                    this.processErrorResponse(exception);
                }
            }
        }
        catch (IOException e) {
            this.processErrorResponse(e);
        }
    }

    private boolean isResponseSuccessful(Response response) {
        return response != null && response.isSuccessful();
    }

    public void processErrorResponse(Exception e) {
        if (e != null) {
            LPLog.INSTANCE.w(TAG, " Error while sending http request : Error msg: " + e.getMessage(), e);
        } else {
            LPLog.INSTANCE.w(TAG, " Error while sending http request; no exception given");
        }
        if (this.mCallback != null) {
            this.mCallback.onError(e);
        }
    }

    protected void reportSuccess(Response response) throws IOException {
        this.mCallback.onSuccess(response == null ? "" : response.body().string());
    }

    public abstract HttpRequestBody getRequestBody();

    public abstract void setBody(HttpRequestBody var1);

    public void addHeader(String name, String value) {
        if (name.equals(USER_AGENT)) {
            this.mHeaders.set(0, (Pair<String, String>)Pair.create((Object)USER_AGENT, (Object)value));
        } else {
            this.mHeaders.add((Pair<String, String>)Pair.create((Object)name, (Object)value));
        }
    }

    public List<Pair<String, String>> getHeaders() {
        return this.mHeaders;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public void setUrl(String mUrl) {
        this.mUrl = mUrl;
    }

    public HttpMethod getMethod() {
        return this.mMethod;
    }

    public List<String> getCertificatePinningKeys() {
        return this.mCertificatePinningKeys;
    }

    public int getTimeout() {
        return this.mTimeout;
    }

    public void setTimeout(int timeout) {
        this.mTimeout = timeout;
    }

    public ICallback getCallback() {
        return this.mCallback;
    }

    public void setCertificatePinningKeys(List<String> certificatePinningKeys) {
        this.mCertificatePinningKeys = certificatePinningKeys;
    }

    public void setCallback(ICallback callback2) {
        this.mCallback = callback2;
    }

    public static enum HttpMethod {
        GET,
        HEAD,
        POST,
        PUT;

    }
}

