package com.liveperson.infra.controller

import android.content.ContentValues
import com.liveperson.infra.controller.DBEncryptionService.Companion.appEncryptionVersion
import com.liveperson.infra.database.tables.MessagesTable
import com.liveperson.infra.database.transaction_helper.InsertOrUpdateSQLCommand
import com.liveperson.infra.database.transaction_helper.InsertSQLCommand
import com.liveperson.infra.database.transaction_helper.SQLiteCommand
import com.liveperson.infra.database.transaction_helper.UpdateSQLCommand

fun encrypt(messageValues: ContentValues): ContentValues? {
    val messageEncryptionVersion = appEncryptionVersion
    messageValues.put(MessagesTable.KEY_ENCRYPTION_VERSION, messageEncryptionVersion.ordinal)
    // encrypt message`s text received from server
    val message = messageValues.getAsString(MessagesTable.KEY_TEXT)
    if (message != null) {
        val encryptedMessage = DBEncryptionHelper.encrypt(messageEncryptionVersion, message)
        messageValues.put(MessagesTable.KEY_TEXT, encryptedMessage)
    }
    // encrypt message`s metadata received from server
    val metadata = messageValues.getAsString(MessagesTable.KEY_METADATA)
    if (metadata != null) {
        val encryptedMetadata = DBEncryptionHelper.encrypt(messageEncryptionVersion, metadata)
        messageValues.put(MessagesTable.KEY_METADATA, encryptedMetadata)
    }
    return messageValues
}

fun encryptTransactionData(command: SQLiteCommand) {
    when (command.type) {
        SQLiteCommand.CommandType.INSERT -> {
            (command as? InsertSQLCommand)?.contentValues?.let { encrypt(it) }
        }
        SQLiteCommand.CommandType.UPDATE -> {
            (command as? UpdateSQLCommand)?.contentValues?.let { encrypt(it) }
        }
        SQLiteCommand.CommandType.INSERT_OR_UPDATE -> {
            val currentCommand = command as? InsertOrUpdateSQLCommand
            currentCommand?.contentValuesForInsert?.let { encrypt(it) }
            currentCommand?.contentValuesForUpdate?.let { encrypt(it) }
        }
    }
}