package com.liveperson.infra.utils;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.CONSTRUCTOR;
import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.ElementType.LOCAL_VARIABLE;
import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.ElementType.PACKAGE;
import static java.lang.annotation.ElementType.PARAMETER;
import static java.lang.annotation.ElementType.TYPE;

/**
 * This annotation is meat to point out about deprecation date, so the developers could be notified to change the usage.
 */
@Retention(RetentionPolicy.CLASS)
@Target(value={CONSTRUCTOR, FIELD, LOCAL_VARIABLE, METHOD, PACKAGE, PARAMETER, TYPE})
public @interface LPDeprecated {
    /**
     * Timestamp in seconds
     * @return The timestamp in seconds that represents the time when it was  deprecated.
     */
    int since();
}

//TODO Perry, complete this.
/*
Take inspiration from here: https://github.com/gilgoldzweig/Gencycler

Follow this presentation (slide 181): https://drive.google.com/open?id=1mj3AyhLq8aL1Hw0mg-Wyb8RSga1pg9ZgTNA7HEaOXnM#slide=id.g38d4638010_0_3817
 */