/* Copyright (c) LivePerson, Inc. */
package com.liveperson.infra.utils

import com.liveperson.infra.utils.patterns.PatternsCompat

/**
 * Created by Yanda on 05/13/2020
 */
object LinkUtils {

	const val TAG_OPEN = "#md#"
	const val TAG_CLOSE = "#/md#"

	@JvmStatic
	fun containsMarkdownHyperlink(message: String): Boolean {
		return message.contains(TAG_OPEN) && message.contains(TAG_CLOSE)
	}

	/**
	 * Check If text contains web URLs using Patterns
	 */
	@JvmStatic
	fun containsWebUrls(text: String): Boolean {
		val l = text.split("\\s+".toRegex()).toTypedArray()
		for (i in l.indices) {
			if (PatternsCompat.AUTOLINK_WEB_URL.matcher(l[i]).matches()) {
				return true
			}
		}
		return false
	}
}
