/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.database;

import android.os.Handler;
import android.os.Looper;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;

public class DataBaseCommand<DATA> {
    private static final String TAG = "DataBaseCommand";
    private QueryCommand<DATA> mQueryCommand;
    private Handler mUIHandler = new Handler(Looper.getMainLooper());
    protected QueryCallback<DATA> mPostQueryOnUI;
    protected Runnable mPreQueryOnBackground;
    protected QueryCallback<DATA> mPostQueryOnBackground;

    public DataBaseCommand(QueryCommand<DATA> queryCommand) {
        this.mQueryCommand = queryCommand;
    }

    public static <DATA> DataBaseCommand<DATA> create(QueryCommand<DATA> queryCommand) {
        return new DataBaseCommand<DATA>(queryCommand);
    }

    public DataBaseCommand<DATA> setPostQueryOnUI(QueryCallback<DATA> callback2) {
        this.mPostQueryOnUI = callback2;
        return this;
    }

    public DataBaseCommand<DATA> setPreQueryOnBackground(Runnable callback2) {
        this.mPreQueryOnBackground = callback2;
        return this;
    }

    public DataBaseCommand<DATA> setPostQueryOnBackground(QueryCallback<DATA> callback2) {
        this.mPostQueryOnBackground = callback2;
        return this;
    }

    public DATA executeSynchronously() {
        return this.mQueryCommand.query();
    }

    public void execute() {
        DataBaseExecutor.execute(() -> {
            try {
                if (this.mPreQueryOnBackground != null) {
                    this.mPreQueryOnBackground.run();
                }
                DATA data = this.executeSynchronously();
                if (this.mPostQueryOnBackground != null) {
                    this.mPostQueryOnBackground.onResult(data);
                }
                if (this.mPostQueryOnUI != null) {
                    this.mUIHandler.post(() -> this.mPostQueryOnUI.onResult(data));
                }
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000044, "Error while running DataBaseCommand.", e);
            }
        });
    }

    public static interface QueryCallback<T> {
        public void onResult(T var1);
    }

    public static interface QueryCommand<T> {
        public T query();
    }
}

