/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.utils;

import android.os.AsyncTask;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.liveperson.infra.R;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.LinkPreviewCallback;
import com.liveperson.infra.utils.SourceContent;
import com.liveperson.infra.utils.patterns.PatternsCompat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextCrawler {
    private static final String TAG = "TextCrawler";
    private static final String KEY_HTML_TAG_HEAD_OPEN = "<head>";
    private static final String KEY_HTML_TAG_HEAD_CLOSE = "</head>";
    private static final String KEY_HTML_TAG_TITLE = "title";
    private static final String KEY_HTML_TAG_DESCRIPTION = "description";
    private static final String KEY_HTML_TAG_SITE_NAME = "site_name";
    private static final String KEY_EMPTY = "";
    private static final String KEY_HTML_TAG_IMAGE = "image";
    private static final String KEY_HTML_TAG_URL = "url";
    private static final int CONNECT_TIMEOUT_IN_MILLI = 1500;
    private static final int READ_TIMEOUT_IN_MILLI = 5000;
    private static final String HTTP_PROTOCOL_SHORT = "http";
    private static final String HTTP_PROTOCOL = "http://";
    private static final String HTTPS_PROTOCOL = "https://";
    private static final String WWW_SUBDOMAIN = "www.";
    private static final String TITLE_PATTERN = "<title(.*?)>(.*?)</title>";
    private static final String SCRIPT_PATTERN = "<script(.*?)>(.*?)</script>";
    private static final String METATAG_PATTERN = "<meta(.*?)>";
    private static final String METATAG_CONTENT_PATTERN = "content=\"(.*?)\"";
    private LinkPreviewCallback mCallback;
    private SourceContent mSourceContent;
    private GetCode mGetCode;
    private HttpURLConnection hc;
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = Math.max(2, Math.min(CPU_COUNT - 1, 4));
    private static final int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int KEEP_ALIVE_SECONDS = 2;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private final BlockingQueue<Runnable> mDecodeWorkQueue = new LinkedBlockingQueue<Runnable>();

    public void makePreview(LinkPreviewCallback callback2, String url) {
        LPLog.INSTANCE.d(TAG, "makePreview. callback = " + callback2 + " url = " + url);
        if (this.mCallback != null) {
            LPLog.INSTANCE.w(TAG, "makePreview(...) canceled. Make sure You recreated a new TextCrawler object before invoke this method");
            return;
        }
        this.mCallback = callback2;
        this.mSourceContent = new SourceContent();
        if (this.mGetCode != null) {
            this.mGetCode.cancel(true);
            this.mGetCode = null;
        }
        this.mGetCode = new GetCode();
        ThreadPoolExecutor mDecodeThreadPool = new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, 2L, KEEP_ALIVE_TIME_UNIT, this.mDecodeWorkQueue);
        this.mGetCode.executeOnExecutor(mDecodeThreadPool, new String[]{url});
    }

    public static String prepareLink(String text) {
        if (text == null) {
            LPLog.INSTANCE.w(TAG, "matches: given text is null");
            return null;
        }
        String url = null;
        text = text.toLowerCase();
        text = text.replaceAll("\u200b", KEY_EMPTY);
        text = text.replaceAll("\u200c", KEY_EMPTY);
        text = text.replaceAll("\u200c", KEY_EMPTY);
        text = text.replaceAll("\ufeff", KEY_EMPTY);
        String textWithoutEmails = PatternsCompat.EMAIL_ADDRESS.matcher(text).replaceAll(KEY_EMPTY);
        Matcher matcher = PatternsCompat.AUTOLINK_WEB_URL.matcher(textWithoutEmails);
        while (matcher.find()) {
            String string2 = matcher.group();
            boolean shouldFormatUrl = !string2.toLowerCase().startsWith(HTTP_PROTOCOL) && !string2.toLowerCase().startsWith(HTTPS_PROTOCOL);
            String resultString = string2;
            if (shouldFormatUrl) {
                if (!resultString.toLowerCase().startsWith(WWW_SUBDOMAIN)) {
                    resultString = WWW_SUBDOMAIN + resultString;
                }
                resultString = HTTPS_PROTOCOL + resultString;
            }
            try {
                URL item = new URL(resultString);
                LPLog.INSTANCE.i(TAG, "Returned URL: " + item);
                url = item.toString();
            }
            catch (Exception e) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000015, "ERROR", e);
            }
        }
        return url;
    }

    private BufferedReader openConnectionWithAdvancedRedirects() throws IOException {
        String url = this.mSourceContent.getFinalUrl();
        HashMap<String, Integer> visited = new HashMap<String, Integer>();
        block3: while (true) {
            int times;
            if (Build.VERSION.SDK_INT >= 24) {
                times = visited.compute(url, (key, count) -> count == null ? 1 : count + 1);
            } else if (visited.containsKey(url)) {
                Integer oldValue = (Integer)visited.get(url);
                visited.remove(url);
                oldValue = oldValue + 1;
                visited.put(url, oldValue);
                times = oldValue;
            } else {
                visited.put(url, 1);
                times = 1;
            }
            if (times > 3) {
                throw new IOException("Stuck in redirect loop");
            }
            URL resourceUrl = new URL(url);
            this.hc = (HttpURLConnection)resourceUrl.openConnection();
            this.hc.setConnectTimeout(1500);
            this.hc.setReadTimeout(5000);
            this.hc.addRequestProperty("Connection", "keep-alive");
            this.hc.addRequestProperty("User-Agent", System.getProperty("http.agent"));
            this.hc.addRequestProperty("Accept-Language", Locale.getDefault().getLanguage());
            this.hc.setInstanceFollowRedirects(false);
            switch (this.hc.getResponseCode()) {
                case 301: 
                case 302: 
                case 303: {
                    String location = this.hc.getHeaderField("Location");
                    location = URLDecoder.decode(location, "UTF-8");
                    URL base = new URL(url);
                    URL next = new URL(base, location);
                    url = next.toExternalForm();
                    LPLog.INSTANCE.d(TAG, "moving to " + location);
                    continue block3;
                }
            }
            break;
        }
        LPLog.INSTANCE.d(TAG, "response code: " + this.hc.getResponseCode());
        String charset = this.getCharsetEncoding(this.hc.getContentType());
        return new BufferedReader(new InputStreamReader(this.hc.getInputStream(), charset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseHtml(String[] params) {
        String url = TextCrawler.prepareLink(params[0]);
        if (this.mSourceContent == null) {
            this.mSourceContent = new SourceContent();
        }
        if (url == null || url.isEmpty()) {
            this.mSourceContent.setFinalUrl(KEY_EMPTY);
        } else {
            this.mSourceContent.setFinalUrl(this.extendedTrim(url));
            StringBuilder myString = new StringBuilder();
            try {
                String matchTitle;
                String thisLine;
                this.hc = null;
                long openConnectionTime = System.currentTimeMillis();
                BufferedReader br = this.openConnectionWithAdvancedRedirects();
                while ((thisLine = br.readLine()) != null) {
                    myString.append(thisLine);
                }
                br.close();
                LPLog.INSTANCE.d(TAG, "HttpURLConnection reading finished: " + this.mSourceContent.getFinalUrl() + ". Execution time: " + (System.currentTimeMillis() - openConnectionTime) + " ms");
                if (TextUtils.isEmpty((CharSequence)myString)) {
                    throw new IOException("the url is empty");
                }
                if (myString.indexOf(KEY_HTML_TAG_HEAD_OPEN) == -1) {
                    this.mSourceContent.setHtmlCode(this.extendedTrim(myString.toString()));
                } else {
                    this.mSourceContent.setHtmlCode(this.extendedTrim(myString.substring(myString.indexOf(KEY_HTML_TAG_HEAD_OPEN), myString.lastIndexOf(KEY_HTML_TAG_HEAD_CLOSE) + KEY_HTML_TAG_HEAD_CLOSE.length())));
                }
                HashMap<String, String> metaTags = this.getMetaTags(this.mSourceContent.getHtmlCode());
                this.mSourceContent.setMetaTags(metaTags);
                this.mSourceContent.setTitle(metaTags.get(KEY_HTML_TAG_TITLE));
                this.mSourceContent.setDescription(metaTags.get(KEY_HTML_TAG_DESCRIPTION));
                this.mSourceContent.setSiteName(metaTags.get(KEY_HTML_TAG_SITE_NAME));
                if (this.mSourceContent.getTitle().equals(KEY_EMPTY) && !(matchTitle = this.pregMatch(this.mSourceContent.getHtmlCode(), TITLE_PATTERN, 2)).equals(KEY_EMPTY)) {
                    this.mSourceContent.setTitle(matchTitle);
                }
                this.mSourceContent.setDescription(this.mSourceContent.getDescription().replaceAll(SCRIPT_PATTERN, KEY_EMPTY));
                String tagImage = metaTags.get(KEY_HTML_TAG_IMAGE);
                if (tagImage != null && !tagImage.equals(KEY_EMPTY)) {
                    String imageLink = metaTags.get(KEY_HTML_TAG_IMAGE);
                    if (imageLink != null && !imageLink.contains(HTTP_PROTOCOL_SHORT)) {
                        imageLink = this.mSourceContent.getFinalUrl() + imageLink;
                    }
                    this.mSourceContent.setImages(imageLink);
                }
                this.mSourceContent.setSuccess(true);
                LPLog.INSTANCE.d(TAG, "mSourceContent. inited.");
            }
            catch (Exception e) {
                this.mSourceContent.setSuccess(false);
                this.mSourceContent.setUrl(KEY_EMPTY);
                this.mSourceContent.setHtmlCode(KEY_EMPTY);
                LPLog.INSTANCE.w(TAG, "url error: " + e.getMessage(), e);
            }
            finally {
                if (this.hc != null) {
                    this.hc.disconnect();
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.mSourceContent.getFinalUrl())) {
            String[] finalLinkSet = this.mSourceContent.getFinalUrl().split("&");
            this.mSourceContent.setUrl(finalLinkSet[0]);
            this.mSourceContent.setCanonicalUrl(this.canonicalPage(this.mSourceContent.getFinalUrl()));
            this.mSourceContent.setDescription(this.mSourceContent.getDescription());
            this.mSourceContent.setSiteName(this.mSourceContent.getSiteName());
        }
    }

    @NonNull
    private String getCharsetEncoding(String contentType) {
        String charset = KEY_EMPTY;
        if (!TextUtils.isEmpty((CharSequence)contentType)) {
            String[] values;
            for (String value : values = contentType.split(";")) {
                if (!(value = value.trim()).toLowerCase().startsWith("charset=")) continue;
                charset = value.substring("charset=".length());
            }
        }
        if (KEY_EMPTY.equals(charset)) {
            charset = "UTF-8";
        }
        return charset;
    }

    private String canonicalPage(String url) {
        String canonical = KEY_EMPTY;
        if (url.startsWith(HTTP_PROTOCOL)) {
            url = url.substring(HTTP_PROTOCOL.length());
        } else if (url.startsWith(HTTPS_PROTOCOL)) {
            url = url.substring(HTTPS_PROTOCOL.length());
        }
        int urlLength = url.length();
        for (int i = 0; i < urlLength && url.charAt(i) != '/'; ++i) {
            canonical = canonical + url.charAt(i);
        }
        return canonical;
    }

    private HashMap<String, String> getMetaTags(String content) {
        HashMap<String, String> metaTags = new HashMap<String, String>();
        metaTags.put(KEY_HTML_TAG_URL, KEY_EMPTY);
        metaTags.put(KEY_HTML_TAG_TITLE, KEY_EMPTY);
        metaTags.put(KEY_HTML_TAG_DESCRIPTION, KEY_EMPTY);
        metaTags.put(KEY_HTML_TAG_IMAGE, KEY_EMPTY);
        metaTags.put(KEY_HTML_TAG_SITE_NAME, KEY_EMPTY);
        List<String> matches = this.pregMatchMetaTagPattern(content);
        for (String match : matches) {
            String lowerCase = match.toLowerCase();
            if (Configuration.getBoolean(R.bool.link_preview_to_use_more_than_og_tags)) {
                if (lowerCase.contains("name=\"url\"") || lowerCase.contains("name='url'")) {
                    this.updateMetaTag(metaTags, KEY_HTML_TAG_URL, this.separateMetaTagsContent(match));
                } else if (lowerCase.contains("name=\"title\"") || lowerCase.contains("name='title'")) {
                    this.updateMetaTag(metaTags, KEY_HTML_TAG_TITLE, this.separateMetaTagsContent(match));
                } else if (lowerCase.contains("name=\"description\"") || lowerCase.contains("name='description'")) {
                    this.updateMetaTag(metaTags, KEY_HTML_TAG_DESCRIPTION, this.separateMetaTagsContent(match));
                } else if (lowerCase.contains("name=\"image\"") || lowerCase.contains("name='image'") || lowerCase.contains("itemprop=\"image\"")) {
                    this.updateMetaTag(metaTags, KEY_HTML_TAG_IMAGE, this.separateMetaTagsContent(match));
                } else if (lowerCase.contains("name=\"site_name\"") || lowerCase.contains("name='site_name'")) {
                    this.updateMetaTag(metaTags, KEY_HTML_TAG_SITE_NAME, this.separateMetaTagsContent(match));
                }
            }
            if (lowerCase.contains("property=\"og:url\"") || lowerCase.contains("property='og:url'")) {
                this.updateMetaTag(metaTags, KEY_HTML_TAG_URL, this.separateMetaTagsContent(match));
                continue;
            }
            if (lowerCase.contains("property=\"og:title\"") || lowerCase.contains("property='og:title'")) {
                this.updateMetaTag(metaTags, KEY_HTML_TAG_TITLE, this.separateMetaTagsContent(match));
                continue;
            }
            if (lowerCase.contains("property=\"og:description\"") || lowerCase.contains("property='og:description'")) {
                this.updateMetaTag(metaTags, KEY_HTML_TAG_DESCRIPTION, this.separateMetaTagsContent(match));
                continue;
            }
            if (lowerCase.contains("property=\"og:image\"") || lowerCase.contains("property='og:image'")) {
                this.updateMetaTag(metaTags, KEY_HTML_TAG_IMAGE, this.separateMetaTagsContent(match));
                continue;
            }
            if (!lowerCase.contains("property=\"og:site_name\"") && !lowerCase.contains("property='og:site_name'")) continue;
            this.updateMetaTag(metaTags, KEY_HTML_TAG_SITE_NAME, this.separateMetaTagsContent(match));
        }
        return metaTags;
    }

    private void updateMetaTag(HashMap<String, String> metaTags, String url, String value) {
        if (value != null && value.length() > 0) {
            metaTags.put(url, value);
        }
    }

    private String separateMetaTagsContent(String content) {
        return this.pregMatch(content, METATAG_CONTENT_PATTERN, 1);
    }

    private String extendedTrim(String content) {
        return TextUtils.isEmpty((CharSequence)content) ? KEY_EMPTY : content.replaceAll("\\s+", " ").replace("\n", " ").replace("\r", " ").trim();
    }

    @VisibleForTesting
    public SourceContent getSourceContent() {
        return this.mSourceContent;
    }

    private String pregMatch(String content, String pattern, int index) {
        String match = KEY_EMPTY;
        Matcher matcher = Pattern.compile(pattern).matcher(content);
        if (matcher.find()) {
            match = matcher.group(index);
        }
        return this.extendedTrim(match);
    }

    private List<String> pregMatchMetaTagPattern(String content) {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher matcher = Pattern.compile(METATAG_PATTERN).matcher(content);
        while (matcher.find()) {
            matches.add(this.extendedTrim(matcher.group(1)));
        }
        return matches;
    }

    public class GetCode
    extends AsyncTask<String, Void, Void> {
        GetCode() {
        }

        protected void onPreExecute() {
            LPLog.INSTANCE.d(TextCrawler.TAG, "onPreExecute " + (Object)((Object)this));
            if (TextCrawler.this.mCallback != null) {
                TextCrawler.this.mCallback.onPre();
            }
            super.onPreExecute();
        }

        protected void onPostExecute(Void result) {
            LPLog.INSTANCE.d(TextCrawler.TAG, "onPostExecute " + (Object)((Object)this) + " result " + result + " mSourceContent " + TextCrawler.this.mSourceContent);
            if (TextCrawler.this.mCallback != null) {
                TextCrawler.this.mCallback.onPos(TextCrawler.this.mSourceContent, this.isNull());
            }
            super.onPostExecute((Object)result);
        }

        protected Void doInBackground(String ... params) {
            LPLog.INSTANCE.d(TextCrawler.TAG, "doInBackground " + (Object)((Object)this) + " params = " + Arrays.toString(params));
            TextCrawler.this.parseHtml(params);
            return null;
        }

        public boolean isNull() {
            return !TextCrawler.this.mSourceContent.isSuccess() && TextCrawler.this.extendedTrim(TextCrawler.this.mSourceContent.getHtmlCode()).equals(TextCrawler.KEY_EMPTY);
        }
    }
}

